/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.api.config.json;

import icey.survivaloverhaul.Main;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;

public class JsonItemIdentity {
    @Nullable
    public String nbt;
    @Nullable
    private CompoundNBT compound;

    public JsonItemIdentity(String nbt) {
        this.nbt = nbt;
        this.tryPopulateCompound();
    }

    public void tryPopulateCompound() {
        if (this.compound == null) {
            if (this.nbt == null) {
                this.compound = null;
            } else {
                try {
                    this.compound = JsonToNBT.func_180713_a((String)this.nbt);
                    if (this.compound == null) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    Main.LOGGER.error("An error occured while populating NBT from json data: " + e.getMessage());
                    this.compound = null;
                    this.nbt = null;
                }
            }
        }
    }

    public boolean matches(ItemStack stack) {
        if (stack.func_77942_o()) {
            return this.matches(stack.func_77978_p());
        }
        return this.matches((CompoundNBT)null);
    }

    public boolean matches(JsonItemIdentity sentIdentity) {
        return this.matches(sentIdentity.compound);
    }

    public boolean matches(@Nullable CompoundNBT stackCompound) {
        if (this.nbt == null || this.nbt.isEmpty()) {
            return true;
        }
        this.tryPopulateCompound();
        return this.checkCompounds(this.compound, stackCompound);
    }

    private boolean checkCompounds(CompoundNBT selfCompound, CompoundNBT stackCompound) {
        if (stackCompound == null) {
            return false;
        }
        for (String key : selfCompound.func_150296_c()) {
            INBT a = selfCompound.func_74781_a(key);
            INBT b = stackCompound.func_74781_a(key);
            if (a != null) {
                if (a instanceof CompoundNBT && b instanceof CompoundNBT) {
                    if (this.checkCompounds((CompoundNBT)a, (CompoundNBT)b)) continue;
                    return false;
                }
                if (a.equals(b)) continue;
                return false;
            }
            if (b == null) continue;
            return false;
        }
        return true;
    }
}

