/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.api.config.json.temperature;

import com.google.gson.annotations.SerializedName;
import icey.survivaloverhaul.api.config.json.temperature.JsonPropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;

public class JsonPropertyTemperature {
    @SerializedName(value="properties")
    public Map<String, String> properties;
    @SerializedName(value="temperature")
    public float temperature;

    public JsonPropertyTemperature(float temperature, JsonPropertyValue ... props) {
        this.temperature = temperature;
        this.properties = new HashMap<String, String>();
        for (JsonPropertyValue prop : props) {
            this.properties.put(prop.property, prop.value);
        }
    }

    public JsonPropertyValue[] getAsPropertyArray() {
        ArrayList<JsonPropertyValue> jpvList = new ArrayList<JsonPropertyValue>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            jpvList.add(new JsonPropertyValue(entry.getKey(), entry.getValue()));
        }
        return jpvList.toArray(new JsonPropertyValue[0]);
    }

    public boolean matchesState(BlockState blockState) {
        for (Property property : blockState.func_235904_r_()) {
            String name = property.func_177701_a();
            if (!this.properties.containsKey(name)) continue;
            String stateValue = blockState.func_177229_b(property).toString();
            if (this.properties.get(name).equals(stateValue)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesDescribedProperties(JsonPropertyValue ... props) {
        if (props.length != this.properties.keySet().size()) {
            return false;
        }
        for (JsonPropertyValue prop : props) {
            if (!this.properties.containsKey(prop.property)) {
                return false;
            }
            if (prop.value.equals(this.properties.get(prop.property))) continue;
            return false;
        }
        return true;
    }
}

