/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.api.temperature;

import icey.survivaloverhaul.api.config.json.temperature.JsonBiomeIdentity;
import icey.survivaloverhaul.api.temperature.TemperatureEnum;
import icey.survivaloverhaul.config.json.JsonConfig;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class ModifierBase
extends ForgeRegistryEntry<ModifierBase> {
    protected final float defaultTemperature = (TemperatureEnum.NORMAL.getUpperBound() + TemperatureEnum.COLD.getUpperBound()) / 2;

    public float getPlayerInfluence(PlayerEntity player) {
        return 0.0f;
    }

    public float getWorldInfluence(World world, BlockPos pos) {
        return 0.0f;
    }

    protected float applyUndergroundEffect(float temperature, World world, BlockPos pos) {
        if (pos.func_177956_o() > 64) {
            return temperature;
        }
        if (world.func_230315_m_().func_236037_d_()) {
            return temperature;
        }
        if (world.func_226660_f_(pos) || world.func_226660_f_(pos.func_177984_a())) {
            return temperature;
        }
        int cutoff = 48;
        if (pos.func_177956_o() <= cutoff || cutoff == 64) {
            return 0.0f;
        }
        return temperature * (float)(pos.func_177956_o() - cutoff) / (64.0f - (float)cutoff);
    }

    protected float getTempForBiome(Biome biome) {
        String name = biome.getRegistryName().toString();
        if (JsonConfig.biomeOverrides.containsKey(name)) {
            JsonBiomeIdentity identity = JsonConfig.biomeOverrides.get(name);
            return this.clampTemperature(identity.temperature);
        }
        return this.clampTemperature(biome.func_242445_k());
    }

    protected float clampTemperature(float temp) {
        return MathHelper.func_76131_a((float)temp, (float)0.0f, (float)1.5f) / 1.5f;
    }

    protected float normalizeToPosNeg(float value) {
        return value * 2.0f - 1.0f;
    }

    public String toString() {
        return this.getRegistryName().toString();
    }
}

