/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.api.temperature;

public enum TemperatureEnum {
    FROSTBITE(0, 6),
    COLD(7, 12),
    NORMAL(13, 18),
    HOT(19, 24),
    HEAT_STROKE(25, 30);

    private int lowerBound;
    private int upperBound;

    private TemperatureEnum(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public boolean matches(int temperature) {
        return temperature >= this.lowerBound && temperature <= this.upperBound;
    }

    public int getMiddle() {
        return (this.upperBound + this.lowerBound) / 2;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }
}

