/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.client;

import icey.survivaloverhaul.api.config.json.temperature.JsonArmorIdentity;
import icey.survivaloverhaul.config.json.JsonConfig;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivaloverhaul", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipHandler {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b()) {
            List tooltip = event.getToolTip();
            float temperature = 0.0f;
            float insulation = 1.0f;
            List<JsonArmorIdentity> identities = JsonConfig.armorTemperatures.get(stack.func_77973_b().getRegistryName().toString());
            if (identities != null) {
                for (JsonArmorIdentity jai : identities) {
                    if (!jai.matches(stack)) continue;
                    temperature = jai.temperature;
                    insulation = jai.insulation;
                    break;
                }
            } else {
                return;
            }
            Object tempTranslation = temperature > 0.0f ? new TranslationTextComponent("survivaloverhaul.armorTooltip.heating") : (temperature < 0.0f ? new TranslationTextComponent("survivaloverhaul.armorTooltip.cooling") : new StringTextComponent("Error"));
            if (temperature != 0.0f) {
                String tempTxt = (temperature % 1.0f == 0.0f ? (float)((int)Math.abs(temperature)) : Math.abs(temperature)) + " ";
                IFormattableTextComponent text = new StringTextComponent("+").func_240699_a_(TextFormatting.BLUE).func_240702_b_(tempTxt).func_230529_a_((ITextComponent)tempTranslation);
                tooltip.add(text);
            }
        }
    }
}

