/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.client.hud;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import icey.survivaloverhaul.api.temperature.TemperatureEnum;
import icey.survivaloverhaul.common.capability.temperature.TemperatureCapability;
import icey.survivaloverhaul.common.capability.wetness.WetnessCapability;
import icey.survivaloverhaul.common.capability.wetness.WetnessMode;
import icey.survivaloverhaul.config.Config;
import icey.survivaloverhaul.util.CapabilityUtil;
import icey.survivaloverhaul.util.MathUtil;
import icey.survivaloverhaul.util.RenderUtil;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivaloverhaul", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TemperatureGUI {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static int updateCounter = 0;
    private static final Random rand = new Random();
    public static final ResourceLocation ICONS = new ResourceLocation("survivaloverhaul", "textures/gui/overlay.png");
    private static final int temperatureTexturePosY = 48;
    private static final int temperatureTextureWidth = 16;
    private static final int temperatureTextureHeight = 16;
    private static final int wetnessTexturePosY = 96;
    private static final int wetnessTextureWidth = 9;
    private static final int wetnessTextureHeight = 9;
    private static int oldTemperature = -1;
    private static int frameCounter = -1;
    private static boolean risingTemperature = false;
    private static boolean startAnimation = false;
    private static int lastWetnessSymbol = 0;
    private static int flashCounter = -1;
    public static boolean shakeSide = false;

    @SubscribeEvent
    public static void renderHud(RenderGameOverlayEvent event) {
        if ((event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE || event.getType() == RenderGameOverlayEvent.ElementType.JUMPBAR) && Config.Baked.temperatureEnabled && TemperatureGUI.mc.field_71442_b.func_78763_f()) {
            int scaledWidth = mc.func_228018_at_().func_198107_o();
            int scaledHeight = mc.func_228018_at_().func_198087_p();
            rand.setSeed(updateCounter * 445);
            TemperatureGUI.bind(ICONS);
            TemperatureGUI.renderGUI(event.getMatrixStack(), (PlayerEntity)TemperatureGUI.mc.field_71439_g, scaledWidth, scaledHeight);
            TemperatureGUI.bind(AbstractGui.field_230665_h_);
        }
    }

    public static void renderGUI(MatrixStack matrix, PlayerEntity player, int width, int height) {
        RenderSystem.enableBlend();
        TemperatureCapability tempCap = CapabilityUtil.getTempCapability(player);
        WetnessCapability wetCap = CapabilityUtil.getWetnessCapability(player);
        switch (Config.Baked.temperatureDisplayMode) {
            case SYMBOL: {
                TemperatureGUI.drawTemperatureAsSymbol(matrix, tempCap, width, height);
                break;
            }
        }
        if (Config.Baked.wetnessMode == WetnessMode.DYNAMIC) {
            TemperatureGUI.drawWetness(matrix, wetCap, width, height);
        }
        RenderSystem.disableBlend();
    }

    public static void drawTemperatureAsSymbol(MatrixStack matrix, TemperatureCapability cap, int width, int height) {
        boolean isDying;
        IconPair icon;
        int x = width / 2 - 8;
        int y = height - 54;
        int xOffset = 0;
        int yOffset = 0;
        int temperature = cap.getTemperatureLevel();
        TemperatureEnum tempEnum = cap.getTemperatureEnum();
        int shakeFrequency = 0;
        switch (tempEnum) {
            case HEAT_STROKE: {
                icon = IconPair.FIRE;
                if (temperature == TemperatureEnum.HEAT_STROKE.getLowerBound()) {
                    shakeFrequency = 0;
                    break;
                }
                if (temperature >= TemperatureEnum.HEAT_STROKE.getMiddle()) {
                    shakeFrequency = 1;
                    break;
                }
                shakeFrequency = 2;
                break;
            }
            case HOT: {
                icon = IconPair.ABOVE_NORMAL;
                break;
            }
            case NORMAL: {
                icon = IconPair.NORMAL;
                break;
            }
            case COLD: {
                icon = IconPair.BELOW_NORMAL;
                break;
            }
            case FROSTBITE: {
                icon = IconPair.SNOWFLAKE;
                if (temperature == TemperatureEnum.FROSTBITE.getUpperBound()) {
                    shakeFrequency = 0;
                    break;
                }
                if (temperature > TemperatureEnum.FROSTBITE.getMiddle() + 1) {
                    shakeFrequency = 2;
                    break;
                }
                shakeFrequency = 1;
                break;
            }
            default: {
                icon = IconPair.UNKNOWN;
            }
        }
        boolean bl = isDying = TemperatureEnum.FROSTBITE.getMiddle() >= cap.getTemperatureLevel() || TemperatureEnum.HEAT_STROKE.getMiddle() < cap.getTemperatureLevel();
        if (shakeFrequency > 0) {
            if (updateCounter % shakeFrequency == 0 && !isDying) {
                int shakeCheck = updateCounter / shakeFrequency;
                shakeSide = shakeCheck % 2 == 0;
                xOffset = shakeSide ? 1 : -1;
            } else if (isDying) {
                xOffset = rand.nextFloat() > 0.5f ? 1 : -1;
                yOffset = rand.nextFloat() > 0.5f ? 1 : -1;
            }
        }
        xOffset += Config.Baked.temperatureDisplayOffsetX;
        yOffset += Config.Baked.temperatureDisplayOffsetY;
        if (frameCounter >= 22) {
            icon = icon.getFlashVariant();
        }
        Matrix4f m4f = matrix.func_227866_c_().func_227870_a_();
        RenderUtil.drawTexturedModelRect(m4f, x + xOffset, y + yOffset, 16 * icon.getIconIndex(), 48, 16, 16);
        RenderUtil.drawTexturedModelRect(m4f, x + xOffset, y + yOffset, 16 * icon.getIconHolder(), 48, 16, 16);
        if (oldTemperature == -1) {
            oldTemperature = temperature;
        }
        if (oldTemperature != temperature) {
            risingTemperature = oldTemperature < temperature;
            oldTemperature = temperature;
            startAnimation = true;
        }
        int ovrXOffset = 16 * (frameCounter / 2 - 1);
        int ovrYOffset = 48 + 16 * (risingTemperature ? 1 : 2);
        RenderUtil.drawTexturedModelRect(m4f, x + xOffset, y + yOffset, ovrXOffset, ovrYOffset, 16, 16);
    }

    public static void drawWetness(MatrixStack matrix, WetnessCapability cap, int width, int height) {
        int wetness = cap.getWetness();
        int x = width / 2 - 4;
        int y = height - 62;
        int xOffset = Config.Baked.wetnessIndicatorOffsetX;
        int yOffset = Config.Baked.wetnessIndicatorOffsetY;
        if (wetness == 0) {
            return;
        }
        byte wetnessSymbol = (byte)MathHelper.func_76131_a((float)(MathUtil.invLerp(0.0f, 400.0f, wetness) * 4.0f), (float)0.0f, (float)3.0f);
        if (lastWetnessSymbol != wetnessSymbol) {
            flashCounter = 3;
            lastWetnessSymbol = wetnessSymbol;
        }
        int texPosX = wetnessSymbol * 9;
        int texPosY = 96 + (flashCounter >= 0 ? 9 : 0);
        Matrix4f m4f = matrix.func_227866_c_().func_227870_a_();
        RenderUtil.drawTexturedModelRect(m4f, x + xOffset, y + yOffset, texPosX, texPosY, 9, 9);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !mc.func_147113_T()) {
            ++updateCounter;
            if (frameCounter >= 0) {
                --frameCounter;
            }
            if (flashCounter >= 0) {
                --flashCounter;
            }
            if (startAnimation) {
                frameCounter = 24;
                startAnimation = false;
            }
        }
    }

    private static void bind(ResourceLocation resource) {
        mc.func_110434_K().func_110577_a(resource);
    }

    private static enum IconPair {
        NORMAL(0, 3),
        FIRE(1, 4),
        SNOWFLAKE(2, 5),
        ABOVE_NORMAL(0, 11),
        BELOW_NORMAL(0, 12),
        NORMAL_FLASH(0, 6),
        FIRE_FLASH(1, 7),
        SNOWFLAKE_FLASH(2, 8),
        ABOVE_NORMAL_FLASH(0, 9),
        BELOW_NORMAL_FLASH(0, 10),
        UNKNOWN(0, 13);

        private int iconIndex;
        private int iconHolder;

        private IconPair(int iconIndex, int iconHolder) {
            this.iconIndex = iconIndex;
            this.iconHolder = iconHolder;
        }

        public int getIconIndex() {
            return this.iconIndex;
        }

        public int getIconHolder() {
            return this.iconHolder;
        }

        public IconPair getFlashVariant() {
            switch (this) {
                case NORMAL: {
                    return NORMAL_FLASH;
                }
                case FIRE: {
                    return FIRE_FLASH;
                }
                case SNOWFLAKE: {
                    return SNOWFLAKE_FLASH;
                }
                case ABOVE_NORMAL: {
                    return ABOVE_NORMAL_FLASH;
                }
                case BELOW_NORMAL: {
                    return BELOW_NORMAL_FLASH;
                }
            }
            return this;
        }
    }
}

