/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class BlockTemperatureCoil
extends Block
implements IWaterLoggable {
    public static final DirectionProperty DIRECTION = BlockStateProperties.field_208155_H;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)4.25, (double)0.0, (double)4.25, (double)11.75, (double)16.0, (double)11.75), Block.func_208617_a((double)4.25, (double)0.0, (double)4.25, (double)11.75, (double)16.0, (double)11.75), Block.func_208617_a((double)4.25, (double)4.25, (double)0.0, (double)11.75, (double)11.75, (double)16.0), Block.func_208617_a((double)4.25, (double)4.25, (double)0.0, (double)11.75, (double)11.75, (double)16.0), Block.func_208617_a((double)0.0, (double)4.25, (double)4.25, (double)16.0, (double)11.75, (double)11.75), Block.func_208617_a((double)0.0, (double)4.25, (double)4.25, (double)16.0, (double)11.75, (double)11.75)};
    public final CoilType coilType;

    public BlockTemperatureCoil(CoilType coilType) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(4.0f, 10.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_226896_b_());
        this.coilType = coilType;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.DOWN)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            boolean powered = worldIn.func_175640_z(pos);
            boolean enabled = (Boolean)state.func_177229_b((Property)POWERED);
            if (enabled && !powered) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            } else if (!enabled && powered) {
                this.turnOn(worldIn, pos, state);
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && !worldIn.func_175640_z(pos)) {
            this.turnOff((World)worldIn, pos, state);
        }
    }

    private void turnOff(World world, BlockPos pos, BlockState state) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    private void turnOn(World world, BlockPos pos, BlockState state) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DIRECTION, (Comparable)context.func_196000_l().func_176734_d())).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DIRECTION, POWERED, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b((Property)DIRECTION)).func_176745_a()];
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public static enum CoilType {
        COOLING("cooling", -1.0f),
        HEATING("heating", 1.0f),
        BROKEN("broken", 0.0f);

        private String name;
        private float temperature;

        private CoilType(String name, float temperature) {
            this.name = name;
            this.temperature = temperature;
        }

        public String getName() {
            return this.name;
        }

        public float getTemperatureMultiplier() {
            return this.temperature;
        }
    }
}

