/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.capability;

import icey.survivaloverhaul.Main;
import icey.survivaloverhaul.api.config.json.temperature.JsonConsumableTemperature;
import icey.survivaloverhaul.common.capability.heartmods.HeartModifierCapability;
import icey.survivaloverhaul.common.capability.heartmods.HeartModifierProvider;
import icey.survivaloverhaul.common.capability.temperature.TemperatureCapability;
import icey.survivaloverhaul.common.capability.temperature.TemperatureProvider;
import icey.survivaloverhaul.common.capability.wetness.WetnessCapability;
import icey.survivaloverhaul.common.capability.wetness.WetnessMode;
import icey.survivaloverhaul.config.Config;
import icey.survivaloverhaul.config.json.JsonConfig;
import icey.survivaloverhaul.network.NetworkHandler;
import icey.survivaloverhaul.network.packets.UpdateHeartsPacket;
import icey.survivaloverhaul.network.packets.UpdateTemperaturesPacket;
import icey.survivaloverhaul.network.packets.UpdateWetnessPacket;
import icey.survivaloverhaul.util.CapabilityUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="survivaloverhaul", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModCapabilities {
    public static final ResourceLocation TEMPERATURE_RES = new ResourceLocation("survivaloverhaul", "temperature");
    public static final ResourceLocation HEART_MOD_RES = new ResourceLocation("survivaloverhaul", "heart_modifier");
    public static final ResourceLocation WETNESS_RES = new ResourceLocation("survivaloverhaul", "wetness");

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity && event.getObject() instanceof PlayerEntity) {
            event.addCapability(TEMPERATURE_RES, (ICapabilityProvider)new TemperatureProvider());
            event.addCapability(HEART_MOD_RES, (ICapabilityProvider)new HeartModifierProvider());
            event.addCapability(WETNESS_RES, (ICapabilityProvider)new WetnessCapability.Provider(new WetnessCapability()));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = event.player;
        World world = player.field_70170_p;
        if (Config.Baked.temperatureEnabled && !ModCapabilities.shouldSkipTick(player)) {
            TemperatureCapability tempCap = CapabilityUtil.getTempCapability(player);
            tempCap.tickUpdate(player, world, event.phase);
            if (event.phase == TickEvent.Phase.START && (tempCap.isDirty() || tempCap.getPacketTimer() % Config.Baked.routinePacketSync == 0)) {
                tempCap.setClean();
                ModCapabilities.sendTemperatureUpdate(player);
            }
        }
        if (Config.Baked.wetnessMode == WetnessMode.DYNAMIC && !ModCapabilities.shouldSkipTick(player)) {
            WetnessCapability wetCap = CapabilityUtil.getWetnessCapability(player);
            wetCap.tickUpdate(player, world, event.phase);
            if (event.phase == TickEvent.Phase.START && wetCap.getPacketTimer() % Config.Baked.routinePacketSync == 0 && wetCap.isDirty()) {
                wetCap.setClean();
                ModCapabilities.sendWetnessUpdate(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUseItemFinish(LivingEntityUseItemEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getEntityLiving().field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack stack = event.getItem();
            List<JsonConsumableTemperature> consumableList = JsonConfig.consumableTemperature.get(stack.func_77973_b().getRegistryName().toString());
            if (consumableList != null) {
                for (JsonConsumableTemperature jct : consumableList) {
                    if (jct == null || !jct.matches(stack)) continue;
                    CapabilityUtil.getTempCapability(player).setTemporaryModifier(jct.group, jct.temperature, jct.duration);
                }
            }
        }
    }

    @SubscribeEvent
    public static void deathHandler(PlayerEvent.Clone event) {
        PlayerEntity orig = event.getOriginal();
        PlayerEntity player = event.getPlayer();
        if (event.isWasDeath()) {
            if (Config.Baked.heartFruitsEnabled && Config.Baked.heartsLostOnDeath >= 0) {
                HeartModifierCapability oldCap = CapabilityUtil.getHeartModCapability(orig);
                HeartModifierCapability newCap = CapabilityUtil.getHeartModCapability(player);
                int oldHearts = oldCap.getAdditionalHearts();
                newCap.setMaxHealth(oldHearts - Config.Baked.heartsLostOnDeath);
                newCap.updateMaxHealth(player.func_130014_f_(), player);
                ModCapabilities.sendHeartsUpdate(player);
            }
        } else {
            Object newCap;
            Object oldCap;
            if (Config.Baked.temperatureEnabled) {
                oldCap = CapabilityUtil.getTempCapability(orig);
                newCap = CapabilityUtil.getTempCapability(player);
                ((TemperatureCapability)newCap).readNBT(((TemperatureCapability)oldCap).writeNBT());
                ModCapabilities.sendTemperatureUpdate(player);
            }
            if (Config.Baked.heartFruitsEnabled) {
                oldCap = CapabilityUtil.getHeartModCapability(orig);
                newCap = CapabilityUtil.getHeartModCapability(player);
                ((HeartModifierCapability)newCap).readNBT(((HeartModifierCapability)oldCap).writeNBT());
                ((HeartModifierCapability)newCap).updateMaxHealth(player.func_130014_f_(), player);
                ModCapabilities.sendHeartsUpdate(player);
            }
            if (Config.Baked.wetnessMode == WetnessMode.DYNAMIC) {
                oldCap = CapabilityUtil.getWetnessCapability(orig);
                newCap = CapabilityUtil.getWetnessCapability(player);
                ((WetnessCapability)newCap).readNBT(((WetnessCapability)oldCap).writeNBT());
                ModCapabilities.sendWetnessUpdate(player);
            }
        }
    }

    private static void sendTemperatureUpdate(PlayerEntity player) {
        if (!player.field_70170_p.func_201670_d()) {
            UpdateTemperaturesPacket packet = new UpdateTemperaturesPacket(Main.TEMPERATURE_CAP.getStorage().writeNBT(Main.TEMPERATURE_CAP, (Object)CapabilityUtil.getTempCapability(player), null));
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)packet);
        }
    }

    private static void sendHeartsUpdate(PlayerEntity player) {
        if (!player.field_70170_p.func_201670_d()) {
            UpdateHeartsPacket packet = new UpdateHeartsPacket(Main.HEART_MOD_CAP.getStorage().writeNBT(Main.HEART_MOD_CAP, (Object)CapabilityUtil.getHeartModCapability(player), null));
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)packet);
        }
    }

    private static void sendWetnessUpdate(PlayerEntity player) {
        if (!player.field_70170_p.func_201670_d()) {
            UpdateWetnessPacket packet = new UpdateWetnessPacket(Main.WETNESS_CAP.getStorage().writeNBT(Main.WETNESS_CAP, (Object)CapabilityUtil.getWetnessCapability(player), null));
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)packet);
        }
    }

    @SubscribeEvent
    public static void syncCapsOnDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        if (Config.Baked.temperatureEnabled) {
            ModCapabilities.sendTemperatureUpdate(player);
        }
        if (Config.Baked.heartFruitsEnabled) {
            ModCapabilities.sendHeartsUpdate(player);
        }
        if (Config.Baked.wetnessMode == WetnessMode.DYNAMIC) {
            ModCapabilities.sendWetnessUpdate(player);
        }
    }

    @SubscribeEvent
    public static void syncCapsOnLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (Config.Baked.temperatureEnabled) {
            ModCapabilities.sendTemperatureUpdate(player);
        }
        if (Config.Baked.heartFruitsEnabled) {
            ModCapabilities.sendHeartsUpdate(player);
        }
        if (Config.Baked.wetnessMode == WetnessMode.DYNAMIC) {
            ModCapabilities.sendWetnessUpdate(player);
        }
    }

    protected static boolean shouldSkipTick(PlayerEntity player) {
        return player.func_184812_l_() || player.func_175149_v();
    }
}

