/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.capability.heartmods;

import icey.survivaloverhaul.api.heartmod.IHeartModifierCapability;
import icey.survivaloverhaul.config.Config;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class HeartModifierCapability
implements IHeartModifierCapability {
    public static final UUID HEART_MODIFIER_ATTRIBUTE = UUID.fromString("b158dbba-c193-4301-9dfd-82c4347b2cf4");
    private int extraHearts;
    private int oldExtraHearts;
    private boolean manualDirty;
    private int packetTimer;

    public HeartModifierCapability() {
        this.init();
    }

    public void init() {
        this.extraHearts = 0;
        this.oldExtraHearts = 0;
        this.manualDirty = false;
        this.packetTimer = 0;
    }

    public void updateMaxHealth(World world, PlayerEntity player) {
        ModifiableAttributeInstance health = player.func_110148_a(Attributes.field_233818_a_);
        AttributeModifier modifier = health.func_111127_a(HEART_MODIFIER_ATTRIBUTE);
        if (modifier != null) {
            health.func_111124_b(modifier);
        }
        health.func_233769_c_(new AttributeModifier(HEART_MODIFIER_ATTRIBUTE, "survivaloverhaul:extra_hearts", (double)(this.extraHearts * 2), AttributeModifier.Operation.ADDITION));
    }

    public void setMaxHealth(int extraHearts) {
        this.extraHearts = MathHelper.func_76125_a((int)extraHearts, (int)0, (int)Config.Baked.maxAdditionalHearts);
    }

    public void addMaxHealth(int extraHearts) {
        this.setMaxHealth(this.extraHearts + extraHearts);
    }

    @Override
    public int getAdditionalHearts() {
        return this.extraHearts;
    }

    @Override
    public boolean isDirty() {
        return this.extraHearts != this.oldExtraHearts || this.manualDirty;
    }

    @Override
    public void setClean() {
        this.oldExtraHearts = this.extraHearts;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }

    public CompoundNBT writeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("extraHearts", this.extraHearts);
        return compound;
    }

    public void readNBT(CompoundNBT compound) {
        this.init();
        if (compound.func_74764_b("extraHearts")) {
            this.setMaxHealth(compound.func_74762_e("extraHearts"));
        }
    }
}

