/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.capability.temperature;

import com.google.common.collect.ImmutableMap;
import icey.survivaloverhaul.Main;
import icey.survivaloverhaul.api.temperature.ITemperatureCapability;
import icey.survivaloverhaul.api.temperature.TemperatureEnum;
import icey.survivaloverhaul.api.temperature.TemperatureUtil;
import icey.survivaloverhaul.api.temperature.TemporaryModifier;
import icey.survivaloverhaul.config.Config;
import icey.survivaloverhaul.registry.EffectRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;

public class TemperatureCapability
implements ITemperatureCapability {
    private int temperature;
    private int tickTimer;
    private Map<String, TemporaryModifier> temporaryModifiers;
    private int oldTemperature;
    private int updateTimer;
    private int targetTemp;
    private boolean manualDirty;
    private int oldModifierSize;
    private int packetTimer;

    public TemperatureCapability() {
        this.init();
    }

    public void init() {
        this.temperature = TemperatureEnum.NORMAL.getMiddle();
        this.tickTimer = 0;
        this.temporaryModifiers = new HashMap<String, TemporaryModifier>();
        this.oldTemperature = 0;
        this.targetTemp = 0;
        this.manualDirty = false;
        this.oldModifierSize = 0;
        this.packetTimer = 0;
    }

    @Override
    public int getTemperatureLevel() {
        return this.temperature;
    }

    @Override
    public int getTemperatureTickTimer() {
        return this.tickTimer;
    }

    @Override
    public ImmutableMap<String, TemporaryModifier> getTemporaryModifiers() {
        return ImmutableMap.copyOf(this.temporaryModifiers);
    }

    @Override
    public void setTemperatureLevel(int temperature) {
        this.temperature = TemperatureUtil.clampTemperature(temperature);
    }

    @Override
    public void setTemperatureTickTimer(int ticktimer) {
        this.tickTimer = ticktimer;
    }

    @Override
    public void setTemporaryModifier(String name, float temp, int duration) {
        if (temp == 0.0f || !Float.isFinite(temp)) {
            return;
        }
        if (this.getTemporaryModifiers().containsKey((Object)name)) {
            this.manualDirty = true;
        }
        this.temporaryModifiers.put(name, new TemporaryModifier(temp, duration));
    }

    @Override
    public void addTemperatureLevel(int temperature) {
        this.setTemperatureLevel(this.getTemperatureLevel() + temperature);
    }

    @Override
    public void addTemperatureTickTimer(int ticktimer) {
        this.setTemperatureTickTimer(this.tickTimer + ticktimer);
    }

    @Override
    public void clearTemporaryModifiers() {
        this.temporaryModifiers.clear();
    }

    @Override
    public void tickUpdate(PlayerEntity player, World world, TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.START) {
            ++this.packetTimer;
            return;
        }
        ++this.updateTimer;
        if (this.updateTimer >= 5) {
            this.updateTimer = 0;
            this.targetTemp = TemperatureUtil.getPlayerTargetTemperature(player);
        }
        this.addTemperatureTickTimer(1);
        if (this.getTemperatureTickTimer() >= this.getTemperatureTickLimit()) {
            this.setTemperatureTickTimer(0);
            int destinationTemp = TemperatureUtil.clampTemperature(this.targetTemp);
            if (this.getTemperatureLevel() != destinationTemp) {
                this.tickTemperature(this.getTemperatureLevel(), destinationTemp);
            }
            TemperatureEnum tempEnum = this.getTemperatureEnum();
            if (player.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() == Items.field_196180_eI) {
                Main.LOGGER.info((Object)((Object)tempEnum) + ", " + this.getTemperatureLevel() + " -> " + destinationTemp);
            }
            if (tempEnum == TemperatureEnum.HEAT_STROKE) {
                if (!(TemperatureEnum.HEAT_STROKE.getMiddle() >= this.getTemperatureLevel() || player.func_175149_v() || player.func_184812_l_() || this.playerIsImmuneToHeat(player))) {
                    player.func_195063_d((Effect)EffectRegistry.HEAT_STROKE.get());
                    player.func_195064_c(new EffectInstance((Effect)EffectRegistry.HEAT_STROKE.get(), 300, 0, false, true));
                }
            } else if (!(tempEnum != TemperatureEnum.FROSTBITE || TemperatureEnum.FROSTBITE.getMiddle() < this.getTemperatureLevel() || player.func_175149_v() || player.func_184812_l_() || player.func_70644_a((Effect)EffectRegistry.COLD_RESISTANCE.get()))) {
                player.func_195063_d((Effect)EffectRegistry.FROSTBITE.get());
                player.func_195064_c(new EffectInstance((Effect)EffectRegistry.FROSTBITE.get(), 300, 0, false, true));
            }
        }
        this.updateTemporaryModifiers();
    }

    private void updateTemporaryModifiers() {
        HashMap<String, TemporaryModifier> tweaks = new HashMap<String, TemporaryModifier>();
        for (Map.Entry<String, TemporaryModifier> entry : this.temporaryModifiers.entrySet()) {
            TemporaryModifier tm = entry.getValue();
            if (tm.duration <= 0) continue;
            tweaks.put(entry.getKey(), new TemporaryModifier(tm.temperature, tm.duration - 1));
        }
        this.temporaryModifiers.clear();
        this.temporaryModifiers.putAll(tweaks);
        tweaks.clear();
        if (this.oldModifierSize != this.temporaryModifiers.size()) {
            this.manualDirty = true;
        }
        this.oldModifierSize = this.temporaryModifiers.size();
    }

    private boolean playerIsImmuneToHeat(PlayerEntity player) {
        return player.func_70644_a((Effect)EffectRegistry.HEAT_RESISTANCE.get()) || player.func_70644_a(Effects.field_76426_n);
    }

    private void tickTemperature(int currentTemp, int destination) {
        int diff = Math.abs(destination - currentTemp);
        int tickTowards = 1;
        if (diff > 15) {
            tickTowards = 2;
        }
        if (this.getTemperatureLevel() > destination) {
            this.addTemperatureLevel(-tickTowards);
        } else {
            this.addTemperatureLevel(tickTowards);
        }
    }

    private int getTemperatureTickLimit() {
        int tickMax = Config.Baked.maxTickRate;
        int tickMin = Config.Baked.minTickRate;
        int tickrange = tickMax - tickMin;
        int tempRange = TemperatureEnum.HEAT_STROKE.getUpperBound() - TemperatureEnum.FROSTBITE.getLowerBound();
        int currentrange = Math.abs(this.getTemperatureLevel() - this.targetTemp);
        return Math.max(tickMin, tickMax - currentrange * tickrange / tempRange);
    }

    @Override
    public boolean isDirty() {
        return this.manualDirty || this.temperature != this.oldTemperature;
    }

    @Override
    public void setClean() {
        this.oldTemperature = this.temperature;
        this.manualDirty = false;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }

    @Override
    public TemperatureEnum getTemperatureEnum() {
        return TemperatureUtil.getTemperatureEnum(this.getTemperatureLevel());
    }

    public CompoundNBT writeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("temperature", this.temperature);
        compound.func_74768_a("ticktimer", this.tickTimer);
        CompoundNBT modifiers = new CompoundNBT();
        for (String entry : this.temporaryModifiers.keySet()) {
            CompoundNBT savedMod = new CompoundNBT();
            TemporaryModifier modifier = this.temporaryModifiers.get(entry);
            savedMod.func_74776_a("temperature", modifier.temperature);
            savedMod.func_74768_a("duration", modifier.duration);
            modifiers.func_218657_a(entry, (INBT)savedMod);
        }
        compound.func_218657_a("temporaryModifiers", (INBT)modifiers);
        return compound;
    }

    public void readNBT(CompoundNBT compound) {
        this.init();
        if (compound.func_74764_b("temperature")) {
            this.setTemperatureLevel(compound.func_74762_e("temperature"));
        }
        if (compound.func_74764_b("tickTimer")) {
            this.setTemperatureTickTimer(compound.func_74762_e("tickTimer"));
        }
        if (compound.func_74764_b("temporaryModifiers")) {
            this.clearTemporaryModifiers();
            CompoundNBT modifiers = (CompoundNBT)compound.func_74781_a("temporaryModifiers");
            for (String entry : modifiers.func_150296_c()) {
                float modTemp = ((CompoundNBT)modifiers.func_74781_a(entry)).func_74760_g("temperature");
                int modDuration = ((CompoundNBT)modifiers.func_74781_a(entry)).func_74762_e("duration");
                this.setTemporaryModifier(entry, modTemp, modDuration);
            }
        }
    }
}

