/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.capability.wetness;

import icey.survivaloverhaul.Main;
import icey.survivaloverhaul.util.MathUtil;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.LavaFluid;
import net.minecraft.fluid.WaterFluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class WetnessCapability {
    public static final int WETNESS_LIMIT = 400;
    private int wetness;
    private int packetTimer;
    private int oldWetness;

    public WetnessCapability() {
        this.init();
    }

    public void init() {
        this.wetness = 0;
        this.packetTimer = 0;
        this.oldWetness = this.wetness;
    }

    public int getWetness() {
        return this.wetness;
    }

    public void setWetness(int wetness) {
        this.wetness = MathHelper.func_76125_a((int)wetness, (int)0, (int)400);
    }

    public void addWetness(int wetness) {
        this.setWetness(this.wetness + wetness);
    }

    public void tickUpdate(PlayerEntity player, World world, TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.START) {
            ++this.packetTimer;
            return;
        }
        BlockPos pos = player.func_233580_cy_();
        if (player.func_184187_bx() instanceof BoatEntity && !player.func_184187_bx().field_70160_al) {
            pos = pos.func_177984_a();
        }
        if (this.wetness > 0 && (world.func_204610_c(pos).func_206888_e() || world.func_204610_c(pos.func_177984_a()).func_206888_e())) {
            this.worldParticles(player, world);
        }
        if (world.func_72912_H().func_82573_f() % 4L != 0L) {
            return;
        }
        if (player.func_223314_ad() > 0 && !player.func_230279_az_()) {
            this.addWetness(-10);
        }
        if (world.func_175727_C(pos)) {
            this.addWetness(5);
        } else if (world.func_204610_c(pos) != null) {
            FluidState fluidState = world.func_204610_c(pos);
            if (fluidState.func_206888_e()) {
                this.addWetness(-3);
                return;
            }
            Fluid fluid = fluidState.func_206886_c();
            float fractionalLevel = MathUtil.invLerp(1.0f, 8.0f, fluidState.func_206882_g());
            if ((float)player.func_213303_ch().func_82617_b() > (float)pos.func_177956_o() + fractionalLevel + 0.0625f) {
                return;
            }
            if (fluid instanceof ForgeFlowingFluid) {
                ForgeFlowingFluid forgeFluid = (ForgeFlowingFluid)fluidState.func_206886_c();
                if (forgeFluid.getAttributes().isGaseous()) {
                    this.addWetness(-3);
                    return;
                }
                int temperature = forgeFluid.getAttributes().getTemperature();
                if (temperature < 400) {
                    this.addWetness(temperature / 100);
                } else {
                    this.addWetness(-(temperature / 100));
                }
            } else if (fluid instanceof LavaFluid) {
                this.addWetness(-Math.round(40.0f * fractionalLevel));
            } else if (fluid instanceof WaterFluid) {
                this.addWetness(Math.round(8.0f * fractionalLevel));
            } else {
                this.addWetness(Math.round(8.0f * fractionalLevel));
            }
        }
    }

    private void worldParticles(PlayerEntity player, World world) {
        Vector3d pos = player.func_213303_ch();
        AxisAlignedBB box = player.func_174813_aQ();
        int particleSpawnRate = Math.round((1.0f - MathUtil.invLerp(0.0f, 400.0f, this.wetness)) * 10.0f);
        if (particleSpawnRate == 0 || world.func_72912_H().func_82573_f() % (long)particleSpawnRate == 0L) {
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_218425_n, pos.field_72450_a, pos.field_72448_b + box.func_216360_c() / 2.0, pos.field_72449_c, 1, box.func_216364_b() / 3.0, box.func_216360_c() / 4.0, box.func_216362_d() / 3.0, 0.0);
        }
    }

    public boolean isDirty() {
        return this.wetness != this.oldWetness;
    }

    public void setClean() {
        this.oldWetness = this.wetness;
    }

    public int getPacketTimer() {
        return this.packetTimer;
    }

    public CompoundNBT writeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("wetness", this.wetness);
        return compound;
    }

    public void readNBT(CompoundNBT compound) {
        this.init();
        if (compound.func_74764_b("wetness")) {
            this.wetness = compound.func_74762_e("wetness");
        }
    }

    public class Storage
    implements Capability.IStorage<WetnessCapability> {
        public INBT writeNBT(Capability<WetnessCapability> capability, WetnessCapability instance, Direction side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<WetnessCapability> capability, WetnessCapability instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                instance.readNBT((CompoundNBT)nbt);
            }
        }
    }

    public class Provider
    implements ICapabilitySerializable<INBT> {
        private LazyOptional<WetnessCapability> instance = LazyOptional.of(() -> Main.WETNESS_CAP.getDefaultInstance());

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return Main.WETNESS_CAP.orEmpty(cap, this.instance);
        }

        public INBT serializeNBT() {
            return Main.WETNESS_CAP.getStorage().writeNBT(Main.WETNESS_CAP, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null);
        }

        public void deserializeNBT(INBT nbt) {
            Main.WETNESS_CAP.getStorage().readNBT(Main.WETNESS_CAP, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null, nbt);
        }
    }
}

