/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.compat.curios;

import icey.survivaloverhaul.Main;
import icey.survivaloverhaul.api.config.json.temperature.JsonArmorIdentity;
import icey.survivaloverhaul.api.temperature.ModifierBase;
import icey.survivaloverhaul.api.temperature.TemperatureUtil;
import icey.survivaloverhaul.config.json.JsonConfig;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public class CuriosModifier
extends ModifierBase {
    private ICuriosHelper helper;

    @Override
    public float getPlayerInfluence(PlayerEntity player) {
        if (!Main.curiosLoaded) {
            return 0.0f;
        }
        try {
            return this.getUncaughtPlayerInfluence(player);
        }
        catch (Exception e) {
            Main.LOGGER.error("An error has occured with Curios compatability, disabling modifier", (Throwable)e);
            Main.curiosLoaded = false;
            return 0.0f;
        }
    }

    public float getUncaughtPlayerInfluence(PlayerEntity player) {
        if (this.helper == null) {
            this.helper = CuriosApi.getCuriosHelper();
            return 0.0f;
        }
        LazyOptional lazyOptional = this.helper.getEquippedCurios((LivingEntity)player);
        if (lazyOptional.isPresent()) {
            IItemHandler itemHandler = (IItemHandler)lazyOptional.resolve().get();
            float sum = 0.0f;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                sum += this.processStackJson(stack);
                sum += TemperatureUtil.getArmorTemperatureTag(stack);
            }
            return sum;
        }
        return 0.0f;
    }

    private float processStackJson(ItemStack stack) {
        List<JsonArmorIdentity> identity = JsonConfig.armorTemperatures.get(stack.func_77973_b().getRegistryName().toString());
        if (identity != null) {
            for (JsonArmorIdentity jai : identity) {
                if (jai == null || !jai.matches(stack)) continue;
                return jai.temperature;
            }
        }
        return 0.0f;
    }
}

