/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.items;

import icey.survivaloverhaul.Main;
import icey.survivaloverhaul.common.capability.heartmods.HeartModifierCapability;
import icey.survivaloverhaul.config.Config;
import icey.survivaloverhaul.network.NetworkHandler;
import icey.survivaloverhaul.network.packets.UpdateHeartsPacket;
import icey.survivaloverhaul.util.CapabilityUtil;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class ItemHeartFruit
extends Item {
    public static final Food FOOD_STATS = new Food.Builder().func_221456_a(6).func_221454_a(2.5f).func_221455_b().func_221453_d();

    public ItemHeartFruit() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_208103_a(Rarity.RARE).func_221540_a(FOOD_STATS));
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (entity instanceof PlayerEntity && Config.Baked.heartFruitsEnabled) {
            PlayerEntity player = (PlayerEntity)entity;
            HeartModifierCapability cap = CapabilityUtil.getHeartModCapability(player);
            if (!world.field_72995_K) {
                cap.addMaxHealth(Config.Baked.additionalHeartsPerFruit);
                cap.updateMaxHealth(world, player);
                if (Config.Baked.heartFruitsGiveRegen) {
                    player.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 1));
                }
            }
            if (player instanceof ServerPlayerEntity) {
                UpdateHeartsPacket packet = new UpdateHeartsPacket(Main.HEART_MOD_CAP.getStorage().writeNBT(Main.HEART_MOD_CAP, (Object)cap, null));
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)packet);
            }
        }
        return entity.func_213357_a(world, stack);
    }
}

