/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.temperature;

import icey.survivaloverhaul.api.config.json.temperature.JsonArmorIdentity;
import icey.survivaloverhaul.api.temperature.ModifierBase;
import icey.survivaloverhaul.api.temperature.TemperatureEnum;
import icey.survivaloverhaul.api.temperature.TemperatureUtil;
import icey.survivaloverhaul.config.json.JsonConfig;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public class ArmorInsulationModifier
extends ModifierBase {
    @Override
    public float getPlayerInfluence(PlayerEntity player) {
        int worldTemperature = TemperatureUtil.getWorldTemperature(player.field_70170_p, player.func_233580_cy_());
        int diff = TemperatureEnum.NORMAL.getMiddle() - worldTemperature;
        diff = (int)((float)diff * this.checkArmorSlot(player.func_184582_a(EquipmentSlotType.HEAD)));
        diff = (int)((float)diff * this.checkArmorSlot(player.func_184582_a(EquipmentSlotType.CHEST)));
        diff = (int)((float)diff * this.checkArmorSlot(player.func_184582_a(EquipmentSlotType.LEGS)));
        diff = (int)((float)diff * this.checkArmorSlot(player.func_184582_a(EquipmentSlotType.FEET)));
        return -diff;
    }

    private float checkArmorSlot(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 1.0f;
        }
        return (float)Math.sqrt(Math.sqrt(this.processStackJson(stack)));
    }

    private float processStackJson(ItemStack stack) {
        List<JsonArmorIdentity> identity = JsonConfig.armorTemperatures.get(stack.func_77973_b().getRegistryName().toString());
        if (identity != null) {
            for (JsonArmorIdentity jtm : identity) {
                if (jtm == null || !jtm.matches(stack)) continue;
                return jtm.insulation;
            }
        }
        return 0.0f;
    }
}

