/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.temperature;

import icey.survivaloverhaul.api.config.json.temperature.JsonArmorIdentity;
import icey.survivaloverhaul.api.temperature.ModifierBase;
import icey.survivaloverhaul.api.temperature.TemperatureUtil;
import icey.survivaloverhaul.config.Config;
import icey.survivaloverhaul.config.json.JsonConfig;
import icey.survivaloverhaul.registry.EnchantRegistry;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public class ArmorModifier
extends ModifierBase {
    @Override
    public float getPlayerInfluence(PlayerEntity player) {
        float value = 0.0f;
        value += this.checkArmorSlot(player.func_184582_a(EquipmentSlotType.HEAD));
        value += this.checkArmorSlot(player.func_184582_a(EquipmentSlotType.CHEST));
        value += this.checkArmorSlot(player.func_184582_a(EquipmentSlotType.LEGS));
        return value += this.checkArmorSlot(player.func_184582_a(EquipmentSlotType.FEET));
    }

    private float checkArmorSlot(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0.0f;
        }
        float sum = 0.0f;
        int coolingLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantRegistry.COLD_BARRIER.get()), (ItemStack)stack);
        int heatingLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantRegistry.THERMAL_BARRIER.get()), (ItemStack)stack);
        if (coolingLevel > 0) {
            sum = (float)((double)sum - (double)coolingLevel * Config.Baked.enchantmentMultiplier);
        }
        if (heatingLevel > 0) {
            sum = (float)((double)sum + (double)heatingLevel * Config.Baked.enchantmentMultiplier);
        }
        sum += this.processStackJson(stack);
        return sum += TemperatureUtil.getArmorTemperatureTag(stack);
    }

    private float processStackJson(ItemStack stack) {
        List<JsonArmorIdentity> identity = JsonConfig.armorTemperatures.get(stack.func_77973_b().getRegistryName().toString());
        if (identity != null) {
            for (JsonArmorIdentity jtm : identity) {
                if (jtm == null || !jtm.matches(stack)) continue;
                return jtm.temperature;
            }
        }
        return 0.0f;
    }
}

