/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.temperature;

import icey.survivaloverhaul.api.temperature.ModifierBase;
import icey.survivaloverhaul.config.Config;
import icey.survivaloverhaul.config.json.JsonConfig;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BiomeModifier
extends ModifierBase {
    @Override
    public float getWorldInfluence(World world, BlockPos pos) {
        Vector3i[] posOffsets = new Vector3i[]{new Vector3i(0, 0, 0), new Vector3i(10, 0, 0), new Vector3i(-10, 0, 0), new Vector3i(0, 0, 10), new Vector3i(0, 0, -10), new Vector3i(7, 0, 7), new Vector3i(7, 0, -7), new Vector3i(-7, 0, 7), new Vector3i(-7, 0, -7)};
        float biomeAverage = 0.0f;
        long worldTime = world.func_72912_H().func_76073_f() % 24000L;
        for (Vector3i offset : posOffsets) {
            Biome biome = world.func_226691_t_(pos.func_177971_a(offset));
            float humidity = biome.func_76727_i();
            float addedTemperature = this.getTempForBiome(biome);
            String biomeName = biome.getRegistryName().toString();
            if (JsonConfig.biomeOverrides.containsKey(biomeName)) {
                float f = humidity = JsonConfig.biomeOverrides.get((Object)biomeName).isDry ? 0.1f : 0.5f;
            }
            if (humidity < 0.2f && worldTime > 12000L && addedTemperature > 0.85f && !world.func_230315_m_().func_236037_d_()) {
                biomeAverage += addedTemperature / 5.0f;
                continue;
            }
            biomeAverage += addedTemperature;
        }
        return this.applyUndergroundEffect(this.normalizeToPosNeg(biomeAverage /= (float)posOffsets.length) * (float)Config.Baked.biomeTemperatureMultiplier, world, pos);
    }
}

