/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.temperature;

import icey.survivaloverhaul.api.config.json.temperature.JsonPropertyTemperature;
import icey.survivaloverhaul.api.config.json.temperature.JsonTemperature;
import icey.survivaloverhaul.api.temperature.ITemperatureTileEntity;
import icey.survivaloverhaul.api.temperature.ModifierBase;
import icey.survivaloverhaul.config.Config;
import icey.survivaloverhaul.config.json.JsonConfig;
import icey.survivaloverhaul.util.WorldUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockModifier
extends ModifierBase {
    private float coldestValue = 0.0f;
    private float hottestValue = 0.0f;
    private float hotTotal = 0.0f;
    private float coldTotal = 0.0f;

    @Override
    public float getWorldInfluence(World world, BlockPos pos) {
        this.coldestValue = 0.0f;
        this.hottestValue = 0.0f;
        this.hotTotal = 0.0f;
        this.coldTotal = 0.0f;
        this.doBlocksRoutine(world, pos);
        this.doFluidRoutine(world, pos);
        this.doTileEntitiesRoutine(world, pos);
        this.hotTotal -= this.hottestValue;
        this.coldTotal -= this.coldestValue;
        float hotLogValue = this.hottestValue * (float)Math.sqrt(this.easyLog(this.hotTotal));
        float coldLogValue = this.coldestValue * (float)Math.sqrt(this.easyLog(this.coldTotal));
        float result = hotLogValue + coldLogValue;
        if (result > this.hottestValue) {
            return Math.min(this.hottestValue + 2.5f, result);
        }
        if (result < this.coldestValue) {
            return Math.max(this.coldestValue - 2.5f, result);
        }
        return result;
    }

    private void doBlocksRoutine(World world, BlockPos pos) {
        int horizontalDist = Config.Baked.tempInfluenceHorizontalDist;
        int verticalDist = Config.Baked.tempInfluenceVerticalDist;
        for (int x = -horizontalDist; x <= horizontalDist; ++x) {
            for (int y = -verticalDist; y <= verticalDist; ++y) {
                for (int z = -horizontalDist; z <= horizontalDist; ++z) {
                    BlockPos blockPos = pos.func_177982_a(x, y, z);
                    BlockState blockState = world.func_180495_p(blockPos);
                    Block block = blockState.func_177230_c();
                    List<JsonPropertyTemperature> tempInfoList = JsonConfig.blockTemperatures.get(block.getRegistryName().toString());
                    if (tempInfoList == null) continue;
                    for (JsonPropertyTemperature tempInfo : tempInfoList) {
                        float blockTemp;
                        if (tempInfo == null || (blockTemp = tempInfo.temperature) == 0.0f || !tempInfo.matchesState(blockState)) continue;
                        this.processTemp(blockTemp);
                    }
                }
            }
        }
    }

    private void doFluidRoutine(World world, BlockPos pos) {
        int horizontalDist = Config.Baked.tempInfluenceHorizontalDist;
        int verticalDist = Config.Baked.tempInfluenceVerticalDist;
        for (int x = -horizontalDist; x <= horizontalDist; ++x) {
            for (int y = -verticalDist; y <= verticalDist; ++y) {
                for (int z = -horizontalDist; z <= horizontalDist; ++z) {
                    BlockPos blockPos = pos.func_177982_a(x, y, z);
                    FluidState fluidState = world.func_204610_c(blockPos);
                    Fluid fluid = fluidState.func_206886_c();
                    for (Map.Entry<String, JsonTemperature> entry : JsonConfig.fluidTemperatures.entrySet()) {
                        if (entry.getValue() == null || !entry.getKey().contentEquals(fluid.getRegistryName().toString())) continue;
                        this.processTemp(entry.getValue().temperature);
                    }
                }
            }
        }
    }

    private void doTileEntitiesRoutine(World world, BlockPos pos) {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                this.checkChunkAndProcess(world, pos.func_177982_a(x * 16, 0, z * 16), pos);
            }
        }
    }

    private void processTemp(float temp) {
        if (temp == 0.0f) {
            return;
        }
        if (temp >= 0.0f) {
            this.hotTotal += temp;
            if (temp > this.hottestValue) {
                this.hottestValue = temp;
            }
        } else {
            this.coldTotal += temp;
            if (temp < this.coldestValue) {
                this.coldestValue = temp;
            }
        }
    }

    private void checkChunkAndProcess(World world, BlockPos pos, BlockPos selfPos) {
        try {
            if (WorldUtil.isChunkLoaded(world, pos)) {
                Chunk chunk = world.func_72863_F().func_217205_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, false);
                for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                    this.processTemp(this.checkTileEntity(world, (BlockPos)entry.getKey(), (TileEntity)entry.getValue(), selfPos));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private float checkTileEntity(World world, BlockPos pos, TileEntity tileEntity, BlockPos selfPos) {
        double distance = pos.func_177951_i((Vector3i)selfPos);
        if (distance < 2500.0 && tileEntity instanceof ITemperatureTileEntity) {
            return ((ITemperatureTileEntity)tileEntity).getInfluence(selfPos, distance);
        }
        return 0.0f;
    }

    private float easyLog(float f) {
        if (f >= 0.0f) {
            return (float)Math.log10(f + 10.0f);
        }
        return (float)Math.log10(-1.0f * f + 10.0f);
    }
}

