/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.temperature;

import icey.survivaloverhaul.api.config.json.temperature.JsonTemperature;
import icey.survivaloverhaul.api.temperature.ModifierBase;
import icey.survivaloverhaul.common.capability.wetness.WetnessCapability;
import icey.survivaloverhaul.common.capability.wetness.WetnessMode;
import icey.survivaloverhaul.config.Config;
import icey.survivaloverhaul.config.json.JsonConfig;
import icey.survivaloverhaul.util.CapabilityUtil;
import icey.survivaloverhaul.util.MathUtil;
import java.util.Map;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WetModifier
extends ModifierBase {
    @Override
    public float getWorldInfluence(World world, BlockPos pos) {
        if (Config.Baked.wetnessMode != WetnessMode.SIMPLE) {
            return 0.0f;
        }
        FluidState state = world.func_204610_c(pos);
        Fluid fluid = state.func_206886_c();
        if (!state.func_206888_e()) {
            for (Map.Entry<String, JsonTemperature> entry : JsonConfig.fluidTemperatures.entrySet()) {
                if (entry.getValue() == null || !entry.getKey().contentEquals(fluid.getRegistryName().toString())) continue;
                return entry.getValue().temperature;
            }
        }
        if (fluid.func_207187_a((Fluid)Fluids.field_204546_a) || fluid.func_207187_a((Fluid)Fluids.field_207212_b)) {
            return (float)Config.Baked.wetMultiplier;
        }
        if (world.func_175727_C(pos)) {
            return (float)Config.Baked.wetMultiplier;
        }
        return 0.0f;
    }

    @Override
    public float getPlayerInfluence(PlayerEntity player) {
        switch (Config.Baked.wetnessMode) {
            case SIMPLE: {
                float worldInfluence = this.getWorldInfluence(player.field_70170_p, player.func_233580_cy_());
                if (player.func_184187_bx() == null || worldInfluence == 0.0f || !(player.func_184187_bx() instanceof BoatEntity)) break;
                return -worldInfluence;
            }
            case DYNAMIC: {
                WetnessCapability wetCap = CapabilityUtil.getWetnessCapability(player);
                if (wetCap.getWetness() == 0) {
                    return 0.0f;
                }
                return (float)(Config.Baked.wetMultiplier * (double)MathUtil.invLerp(0.0f, 400.0f, wetCap.getWetness()));
            }
        }
        return 0.0f;
    }
}

