/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.common.world;

import icey.survivaloverhaul.config.Config;
import java.util.Arrays;
import java.util.List;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivaloverhaul")
public class LootTableInjectors {
    public static final List<String> HEART_FRUIT_LOOT_TABLES = Arrays.asList("chests/buried_treasure", "chests/jungle_temple", "chests/abandoned_mineshaft", "chests/bastion_treasure", "chests/stronghold_corridor");

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        String prefix = "minecraft:";
        String name = event.getName().toString();
        if (name.startsWith(prefix)) {
            String location = name.substring(name.indexOf(prefix) + prefix.length());
            if (Config.Baked.heartFruitsEnabled && HEART_FRUIT_LOOT_TABLES.contains(location)) {
                event.getTable().addPool(LootTableInjectors.getInjectPool("heart_fruits"));
            }
        }
    }

    public static LootPool getInjectPool(String entryName) {
        return LootPool.func_216096_a().func_216045_a(LootTableInjectors.getInjectEntry(entryName)).name("survivaloverhaul_inject").func_216044_b();
    }

    private static LootEntry.Builder<?> getInjectEntry(String name) {
        ResourceLocation table = new ResourceLocation("survivaloverhaul", "inject/" + name);
        return TableLootEntry.func_216171_a((ResourceLocation)table).func_216086_a(1);
    }
}

