/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.config;

import icey.survivaloverhaul.Main;
import icey.survivaloverhaul.client.hud.TemperatureDisplayEnum;
import icey.survivaloverhaul.common.capability.wetness.WetnessMode;
import icey.survivaloverhaul.config.json.JsonConfigRegistration;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    public static void register() {
        try {
            Files.createDirectory(Main.modConfigPath, new FileAttribute[0]);
            Files.createDirectory(Main.modConfigJsons, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            Main.LOGGER.error("Failed to create Survival Overhaul config directories");
            e.printStackTrace();
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC, "survivaloverhaul/survivaloverhaul-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_SPEC, "survivaloverhaul/survivaloverhaul-common.toml");
        JsonConfigRegistration.init(Main.modConfigJsons.toFile());
    }

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
    }

    public static class Baked {
        public static boolean temperatureEnabled;
        public static boolean dangerousTemperature;
        public static boolean temperatureSecondaryEffects;
        public static boolean biomeEffectsEnabled;
        public static double biomeTemperatureMultiplier;
        public static double rainTemperatureModifier;
        public static double snowTemperatureModifier;
        public static double altitudeModifier;
        public static int minTickRate;
        public static int maxTickRate;
        public static int routinePacketSync;
        public static boolean seasonTemperatureEffects;
        public static double timeMultiplier;
        public static double biomeTimeMultiplier;
        public static int timeShadeModifier;
        public static int tempInfluenceHorizontalDist;
        public static int tempInfluenceVerticalDist;
        public static double sprintModifier;
        public static double onFireModifier;
        public static double enchantmentMultiplier;
        public static double playerHuddlingModifier;
        public static int playerHuddlingRadius;
        public static WetnessMode wetnessMode;
        public static double wetMultiplier;
        public static int earlySpringModifier;
        public static int midSpringModifier;
        public static int lateSpringModifier;
        public static int earlySummerModifier;
        public static int midSummerModifier;
        public static int lateSummerModifier;
        public static int earlyAutumnModifier;
        public static int midAutumnModifier;
        public static int lateAutumnModifier;
        public static int earlyWinterModifier;
        public static int midWinterModifier;
        public static int lateWinterModifier;
        public static boolean heartFruitsEnabled;
        public static int heartsLostOnDeath;
        public static int maxAdditionalHearts;
        public static int additionalHeartsPerFruit;
        public static boolean heartFruitsGiveRegen;
        public static boolean staminaEnabled;
        public static TemperatureDisplayEnum temperatureDisplayMode;
        public static int temperatureDisplayOffsetX;
        public static int temperatureDisplayOffsetY;
        public static int wetnessIndicatorOffsetX;
        public static int wetnessIndicatorOffsetY;

        public static void bakeCommon() {
            try {
                temperatureEnabled = (Boolean)Config.COMMON.temperatureEnabled.get();
                dangerousTemperature = (Boolean)Config.COMMON.dangerousTemperature.get();
                temperatureSecondaryEffects = (Boolean)Config.COMMON.temperatureSecondaryEffects.get();
                altitudeModifier = (Double)Config.COMMON.altitudeModifier.get();
                rainTemperatureModifier = (Double)Config.COMMON.rainTemperatureModifier.get();
                snowTemperatureModifier = (Double)Config.COMMON.snowTemperatureModifier.get();
                biomeEffectsEnabled = (Boolean)Config.COMMON.biomeEffectsEnabled.get();
                biomeTemperatureMultiplier = (Double)Config.COMMON.biomeTemperatureMultiplier.get();
                timeMultiplier = (Double)Config.COMMON.timeMultiplier.get();
                biomeTimeMultiplier = (Double)Config.COMMON.biomeTimeMultiplier.get();
                timeShadeModifier = (Integer)Config.COMMON.timeShadeModifier.get();
                tempInfluenceHorizontalDist = (Integer)Config.COMMON.tempInfluenceHorizontalDist.get();
                tempInfluenceVerticalDist = (Integer)Config.COMMON.tempInfluenceVerticalDist.get();
                minTickRate = (Integer)Config.COMMON.minTickRate.get();
                maxTickRate = (Integer)Config.COMMON.maxTickRate.get();
                routinePacketSync = (Integer)Config.COMMON.routinePacketSync.get();
                onFireModifier = (Double)Config.COMMON.onFireModifier.get();
                sprintModifier = (Double)Config.COMMON.sprintModifier.get();
                enchantmentMultiplier = (Double)Config.COMMON.enchantmentMultiplier.get();
                wetnessMode = WetnessMode.getDisplayFromString((String)Config.COMMON.wetnessMode.get());
                wetMultiplier = (Double)Config.COMMON.wetMultiplier.get();
                playerHuddlingModifier = (Double)Config.COMMON.playerHuddlingModifier.get();
                playerHuddlingRadius = (Integer)Config.COMMON.playerHuddlingRadius.get();
                seasonTemperatureEffects = (Boolean)Config.COMMON.seasonTemperatureEffects.get();
                earlySpringModifier = (Integer)Config.COMMON.earlySpringModifier.get();
                midSpringModifier = (Integer)Config.COMMON.midSpringModifier.get();
                lateSpringModifier = (Integer)Config.COMMON.lateSpringModifier.get();
                earlySummerModifier = (Integer)Config.COMMON.earlySummerModifier.get();
                midSummerModifier = (Integer)Config.COMMON.midSummerModifier.get();
                lateSummerModifier = (Integer)Config.COMMON.lateSummerModifier.get();
                earlyAutumnModifier = (Integer)Config.COMMON.earlyAutumnModifier.get();
                midAutumnModifier = (Integer)Config.COMMON.midAutumnModifier.get();
                lateAutumnModifier = (Integer)Config.COMMON.lateAutumnModifier.get();
                earlyWinterModifier = (Integer)Config.COMMON.earlyWinterModifier.get();
                midWinterModifier = (Integer)Config.COMMON.midWinterModifier.get();
                lateWinterModifier = (Integer)Config.COMMON.lateWinterModifier.get();
                heartFruitsEnabled = (Boolean)Config.COMMON.heartFruitsEnabled.get();
                heartsLostOnDeath = (Integer)Config.COMMON.heartsLostOnDeath.get();
                maxAdditionalHearts = (Integer)Config.COMMON.maxAdditionalHearts.get();
                additionalHeartsPerFruit = (Integer)Config.COMMON.additionalHeartsPerFruit.get();
                heartFruitsGiveRegen = (Boolean)Config.COMMON.heartFruitsGiveRegen.get();
            }
            catch (Exception e) {
                Main.LOGGER.warn("An exception was caused trying to load the common config for Survival Overhaul");
                e.printStackTrace();
            }
        }

        public static void bakeClient() {
            try {
                temperatureDisplayMode = TemperatureDisplayEnum.getDisplayFromString((String)Config.CLIENT.temperatureDisplayMode.get());
                temperatureDisplayOffsetX = (Integer)Config.CLIENT.temperatureDisplayOffsetX.get();
                temperatureDisplayOffsetY = (Integer)Config.CLIENT.temperatureDisplayOffsetY.get();
                wetnessIndicatorOffsetX = (Integer)Config.CLIENT.wetnessIndicatorOffsetX.get();
                wetnessIndicatorOffsetY = (Integer)Config.CLIENT.wetnessIndicatorOffsetY.get();
            }
            catch (Exception e) {
                Main.LOGGER.warn("An exception was caused trying to load the client config for Survival Overhaul.");
                e.printStackTrace();
            }
        }
    }

    public static class Server {
        Server(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<String> temperatureDisplayMode;
        public final ForgeConfigSpec.ConfigValue<Integer> temperatureDisplayOffsetX;
        public final ForgeConfigSpec.ConfigValue<Integer> temperatureDisplayOffsetY;
        public final ForgeConfigSpec.ConfigValue<Integer> wetnessIndicatorOffsetX;
        public final ForgeConfigSpec.ConfigValue<Integer> wetnessIndicatorOffsetY;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{" Options related to the heads up display.", " These options will automatically update upon being saved."}).push("hud");
            builder.push("temperature");
            this.temperatureDisplayMode = builder.comment(new String[]{" How temperature is displayed. Accepted values are as follows:", "    SYMBOL - Display the player's current temperature as a symbol above the hotbar.", "    NONE - Disable the temperature indicator."}).define("Temperature Display Mode", (Object)"SYMBOL");
            this.temperatureDisplayOffsetX = builder.comment(" The X and Y offset of the temperature indicator. Set both to 0 for no offset.").define("Temperature Display X Offset", (Object)0);
            this.temperatureDisplayOffsetY = builder.define("Temperature Display Y Offset", (Object)0);
            builder.push("wetness");
            builder.comment(" The X and Y offset of the wetness indicator. Set both to 0 for no offset.").push("offset");
            this.wetnessIndicatorOffsetX = builder.define("Wetness Indicator X Offset", (Object)0);
            this.wetnessIndicatorOffsetY = builder.define("Wetness Indicator Y Offset", (Object)0);
            builder.pop();
            builder.pop();
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> minTickRate;
        public final ForgeConfigSpec.ConfigValue<Integer> maxTickRate;
        public final ForgeConfigSpec.ConfigValue<Integer> routinePacketSync;
        public final ForgeConfigSpec.ConfigValue<Boolean> temperatureEnabled;
        public final ForgeConfigSpec.ConfigValue<Boolean> dangerousTemperature;
        public final ForgeConfigSpec.ConfigValue<Boolean> temperatureSecondaryEffects;
        public final ForgeConfigSpec.ConfigValue<Boolean> biomeEffectsEnabled;
        public final ForgeConfigSpec.ConfigValue<Double> biomeTemperatureMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> timeMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> biomeTimeMultiplier;
        public final ForgeConfigSpec.ConfigValue<Integer> timeShadeModifier;
        public final ForgeConfigSpec.ConfigValue<Double> altitudeModifier;
        public final ForgeConfigSpec.ConfigValue<Double> sprintModifier;
        public final ForgeConfigSpec.ConfigValue<Double> onFireModifier;
        public final ForgeConfigSpec.ConfigValue<Double> enchantmentMultiplier;
        public final ForgeConfigSpec.ConfigValue<String> wetnessMode;
        public final ForgeConfigSpec.ConfigValue<Double> wetMultiplier;
        public final ForgeConfigSpec.ConfigValue<Integer> tempInfluenceHorizontalDist;
        public final ForgeConfigSpec.ConfigValue<Integer> tempInfluenceVerticalDist;
        public final ForgeConfigSpec.ConfigValue<Double> rainTemperatureModifier;
        public final ForgeConfigSpec.ConfigValue<Double> snowTemperatureModifier;
        public final ForgeConfigSpec.ConfigValue<Double> playerHuddlingModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> playerHuddlingRadius;
        public final ForgeConfigSpec.ConfigValue<Boolean> seasonTemperatureEffects;
        public final ForgeConfigSpec.ConfigValue<Integer> earlySpringModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> midSpringModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> lateSpringModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> earlySummerModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> midSummerModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> lateSummerModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> earlyAutumnModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> midAutumnModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> lateAutumnModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> earlyWinterModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> midWinterModifier;
        public final ForgeConfigSpec.ConfigValue<Integer> lateWinterModifier;
        public final ForgeConfigSpec.ConfigValue<Boolean> heartFruitsEnabled;
        public final ForgeConfigSpec.ConfigValue<Integer> heartsLostOnDeath;
        public final ForgeConfigSpec.ConfigValue<Integer> maxAdditionalHearts;
        public final ForgeConfigSpec.ConfigValue<Integer> additionalHeartsPerFruit;
        public final ForgeConfigSpec.ConfigValue<Boolean> heartFruitsGiveRegen;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{" Options related to enabling/disabling specific features", " See the jsons folder to customize the temperature of specific blocks, liquids, armors, etc.", " To reload your JSONs, type /reload into chat with cheats enabled; The same way you reload datapacks, crafttweaker scripts, etc."}).push("core");
            this.temperatureEnabled = builder.comment(" Whether or not the temperature system is enabled.").define("Temperature Enabled", true);
            this.heartFruitsEnabled = builder.comment(" Whether or not heart fruits are functional and generate in-world.").define("Heart Fruits Enabled", true);
            builder.push("advanced");
            this.routinePacketSync = builder.comment(new String[]{" How often player temperature is regularly synced between the client and server, in ticks.", " Lower values will increase accuracy at the cost of performance"}).defineInRange("Routine Packet Sync", 30, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.comment(" Options related to the temperature system").push("temperature");
            this.dangerousTemperature = builder.comment(" Currently non-functional.").define("Dangerous Temperature Effects", true);
            this.temperatureSecondaryEffects = builder.comment(" Currently non-functional.").define("Secondary Temperature Effects", true);
            this.onFireModifier = builder.comment(" How much of an effect being on fire has on a player's temperature.").define("Player On Fire Modifier", (Object)12.5);
            this.sprintModifier = builder.comment(" How much of an effect sprinting has on a player's temperature.").define("Player Sprint Modifier", (Object)1.5);
            this.enchantmentMultiplier = builder.comment(" Increases/decreases the effect that cooling/heating enchantments have on a player's temperature.").define("Enchantment Modifier", (Object)1.0);
            builder.push("wetness");
            this.wetnessMode = builder.comment(new String[]{" How a player's \"wetness\" is determined. Accepted values are as follows:", "   DISABLE - Disable wetness and any effects on temperature it might have.", "   SIMPLE - Wetness is only based on whether you're in water/rain or not. Slightly better in terms of performance.", "   DYNAMIC - Wetness can change dynamically based on various conditions, and does not instantly go away when moving out of water.", " Any other value will default to DISABLE."}).define("Wetness Mode", (Object)"DYNAMIC");
            this.wetMultiplier = builder.comment(" How much being wet influences the player's temperature.").define("Wetness Modifier", (Object)-7.0);
            builder.pop();
            builder.push("huddling");
            this.playerHuddlingModifier = builder.comment(new String[]{" How much nearby players increase the ambient temperature by.", " Note that this value stacks!"}).define("Player Huddling Modifier", (Object)0.5);
            this.playerHuddlingRadius = builder.comment(" The radius, in blocks, around which players will add to each other's temperature.").defineInRange("Player Huddling Radius", 1, 0, 10);
            builder.pop();
            builder.push("environment");
            this.altitudeModifier = builder.comment(" How much the effects of the player's altitude on temperature are multiplied.").define("Altitude Modifier", (Object)3.0);
            builder.push("biomes");
            this.biomeTemperatureMultiplier = builder.comment(" How much a biome's temperature effects are multiplied.").defineInRange("Biome Temperature Multiplier", 16.0, 0.0, Double.POSITIVE_INFINITY);
            this.biomeEffectsEnabled = builder.comment(" Whether or not biomes will have an effect on a player's temperature.").define("Biomes affect Temperature", true);
            builder.pop();
            builder.push("weather");
            this.rainTemperatureModifier = builder.comment(" How much of an effect rain has on temperature.").define("Rain Temperature Modifier", (Object)-2.0);
            this.snowTemperatureModifier = builder.comment(" How much of an effect snow has on temperature.").define("Snow Temperature Modifier", (Object)-6.0);
            builder.pop();
            builder.push("time");
            builder.push("multipliers");
            this.timeMultiplier = builder.comment(" How strongly the effects of time on temperature are multiplied.").defineInRange("Time Multiplier", 2.0, 0.0, Double.POSITIVE_INFINITY);
            this.biomeTimeMultiplier = builder.comment(" How strongly different biomes affect temperature, based on time.").defineInRange("Biome Time Multiplier", 1.75, 1.0, Double.POSITIVE_INFINITY);
            builder.pop();
            this.timeShadeModifier = builder.comment(new String[]{" Staying in the shade will reduce a player's temperature by this amount.", " Only effective in hot biomes!"}).define("Time Shade Modifier", (Object)-3);
            builder.pop();
            builder.pop();
            builder.push("advanced");
            this.tempInfluenceHorizontalDist = builder.comment(" Maximum horizontal distance, in blocks, where heat sources will have an effect on temperature.").defineInRange("Temperature Influence Horizontal Distance", 3, 1, 10);
            this.tempInfluenceVerticalDist = builder.comment(" Maximum vertical distance, in blocks, where heat sources will have an effect on temperature.").defineInRange("Temperature Influence Vertical Distance", 2, 1, 10);
            builder.push("tickrate");
            this.maxTickRate = builder.comment(" Maximum amount of time between temperature ticks.").defineInRange("Maximum Temperature Tickrate", 200, 20, Integer.MAX_VALUE);
            this.minTickRate = builder.comment(" Minimum amount of time between temperature ticks.").defineInRange("Minimum Temperature Tickrate", 20, 20, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.push("compat");
            builder.push("seasons");
            this.seasonTemperatureEffects = builder.comment(new String[]{" If Serene Seasons is installed, then seasons", " will have an effect on the player's temperature."}).define("Seasons affect Temperature", true);
            builder.comment("Temperature modifiers per season in temperate biomes.").push("temperate");
            builder.push("spring");
            this.earlySpringModifier = builder.define("Early Spring Modifier", (Object)-3);
            this.midSpringModifier = builder.define("Mid Spring Modifier", (Object)0);
            this.lateSpringModifier = builder.define("Late Spring Modifier", (Object)3);
            builder.pop();
            builder.push("summer");
            this.earlySummerModifier = builder.define("Early Summer Modifier", (Object)5);
            this.midSummerModifier = builder.define("Mid Summer Modifier", (Object)8);
            this.lateSummerModifier = builder.define("Late Summer Modifier", (Object)5);
            builder.pop();
            builder.push("autumn");
            this.earlyAutumnModifier = builder.define("Early Autumn Modifier", (Object)3);
            this.midAutumnModifier = builder.define("Mid Autumn Modifier", (Object)0);
            this.lateAutumnModifier = builder.define("Late Autumn Modifier", (Object)-3);
            builder.pop();
            builder.push("winter");
            this.earlyWinterModifier = builder.define("Early Winter Modifier", (Object)-7);
            this.midWinterModifier = builder.define("Mid Winter Modifier", (Object)-12);
            this.lateWinterModifier = builder.define("Late Winter Modifier", (Object)-7);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.pop();
            builder.pop();
            builder.comment(" Options relating to heart fruits").push("heart-fruits");
            this.maxAdditionalHearts = builder.comment(" Maximum number of additional hearts that can be given by Heart Fruits.").defineInRange("Maximum Additional Hearts", 10, 1, Integer.MAX_VALUE);
            this.heartsLostOnDeath = builder.comment(new String[]{" The number of additional hearts lost on death.", " Set to -1 to force loss of all additional hearts on death.", " Set to 0 to make additional hearts permanent."}).defineInRange("Hearts Lost On Death", -1, -1, Integer.MAX_VALUE);
            builder.push("effects");
            this.additionalHeartsPerFruit = builder.comment(" Amount of hearts gained from eating a Heart Fruit.").defineInRange("Additional Hearts Per Heart Fruit", 1, 1, Integer.MAX_VALUE);
            this.heartFruitsGiveRegen = builder.comment(" Whether or not Heart Fruits give a strong regeneration effect.").define("Heart Fruits Give Regen", true);
            builder.pop();
            builder.pop();
        }
    }
}

