/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.config.json;

import com.google.common.collect.Maps;
import icey.survivaloverhaul.api.config.json.JsonItemIdentity;
import icey.survivaloverhaul.api.config.json.temperature.JsonArmorIdentity;
import icey.survivaloverhaul.api.config.json.temperature.JsonBiomeIdentity;
import icey.survivaloverhaul.api.config.json.temperature.JsonConsumableTemperature;
import icey.survivaloverhaul.api.config.json.temperature.JsonPropertyTemperature;
import icey.survivaloverhaul.api.config.json.temperature.JsonPropertyValue;
import icey.survivaloverhaul.api.config.json.temperature.JsonTemperature;
import icey.survivaloverhaul.api.config.json.temperature.JsonTemperatureIdentity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonConfig {
    public static Map<String, List<JsonArmorIdentity>> armorTemperatures = Maps.newHashMap();
    public static Map<String, List<JsonPropertyTemperature>> blockTemperatures = Maps.newHashMap();
    public static Map<String, JsonTemperature> fluidTemperatures = Maps.newHashMap();
    public static Map<String, JsonBiomeIdentity> biomeOverrides = Maps.newHashMap();
    public static Map<String, List<JsonConsumableTemperature>> consumableTemperature = Maps.newHashMap();

    public static boolean registerBlockTemperature(String registryName, float temperature, JsonPropertyValue ... properties) {
        JsonPropertyTemperature jpt;
        int i;
        if (!blockTemperatures.containsKey(registryName)) {
            blockTemperatures.put(registryName, new ArrayList());
        }
        List<JsonPropertyTemperature> currentList = blockTemperatures.get(registryName);
        JsonPropertyTemperature result = new JsonPropertyTemperature(temperature, properties);
        if (properties.length > 0) {
            for (int i2 = 0; i2 < currentList.size(); ++i2) {
                JsonPropertyTemperature jpt2 = currentList.get(i2);
                if (!jpt2.matchesDescribedProperties(properties)) continue;
                currentList.set(i2, result);
                return true;
            }
            currentList.add(result);
            return true;
        }
        for (i = 0; i < currentList.size(); ++i) {
            jpt = currentList.get(i);
            if (jpt.properties.keySet().size() <= 0) continue;
            return false;
        }
        for (i = 0; i < currentList.size(); ++i) {
            jpt = currentList.get(i);
            if (jpt.properties.keySet().size() != 0) continue;
            currentList.set(i, result);
            return true;
        }
        currentList.add(result);
        return true;
    }

    public static void registerArmorTemperature(String registryName, float temperature, float insulation) {
        JsonConfig.registerArmorTemperature(registryName, temperature, insulation, new JsonItemIdentity(null));
    }

    public static void registerArmorTemperature(String registryName, float temperature) {
        JsonConfig.registerArmorTemperature(registryName, temperature, 1.0f, new JsonItemIdentity(null));
    }

    public static void registerArmorTemperature(String registryName, float temperature, JsonItemIdentity identity) {
        JsonConfig.registerArmorTemperature(registryName, temperature, 1.0f, identity);
    }

    public static void registerArmorTemperature(String registryName, float temperature, float insulation, JsonItemIdentity identity) {
        if (!armorTemperatures.containsKey(registryName)) {
            armorTemperatures.put(registryName, new ArrayList());
        }
        List<JsonArmorIdentity> currentList = armorTemperatures.get(registryName);
        JsonArmorIdentity result = new JsonArmorIdentity(temperature, insulation, identity);
        for (int i = 0; i < currentList.size(); ++i) {
            JsonTemperatureIdentity jtm = currentList.get(i);
            if (!jtm.matches(identity)) continue;
            currentList.set(i, result);
            return;
        }
        currentList.add(result);
    }

    public static void registerConsumableTemperature(String group, String registryName, float temperature, int duration, JsonItemIdentity identity) {
        if (!consumableTemperature.containsKey(registryName)) {
            consumableTemperature.put(registryName, new ArrayList());
        }
        List<JsonConsumableTemperature> currentList = consumableTemperature.get(registryName);
        JsonConsumableTemperature result = new JsonConsumableTemperature(group, temperature, duration, identity);
        for (int i = 0; i < currentList.size(); ++i) {
            JsonConsumableTemperature jct = currentList.get(i);
            if (!jct.matches(identity)) continue;
            currentList.set(i, result);
            return;
        }
        currentList.add(result);
    }

    public static void registerFluidTemperature(String registryName, float temperature) {
        fluidTemperatures.put(registryName, new JsonTemperature(temperature));
    }

    public static void registerBiomeOverride(String registryName, float temperature) {
        JsonConfig.registerBiomeOverride(registryName, temperature, false);
    }

    public static void registerBiomeOverride(String registryName, float temperature, boolean isDry) {
        if (!biomeOverrides.containsKey(registryName)) {
            biomeOverrides.put(registryName, new JsonBiomeIdentity(temperature, isDry));
        }
    }
}

