/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.config.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import icey.survivaloverhaul.Main;
import icey.survivaloverhaul.api.config.json.JsonItemIdentity;
import icey.survivaloverhaul.api.config.json.TemporaryModifierGroup;
import icey.survivaloverhaul.api.config.json.temperature.JsonArmorIdentity;
import icey.survivaloverhaul.api.config.json.temperature.JsonBiomeIdentity;
import icey.survivaloverhaul.api.config.json.temperature.JsonConsumableTemperature;
import icey.survivaloverhaul.api.config.json.temperature.JsonPropertyTemperature;
import icey.survivaloverhaul.api.config.json.temperature.JsonPropertyValue;
import icey.survivaloverhaul.api.config.json.temperature.JsonTemperature;
import icey.survivaloverhaul.common.compat.CompatController;
import icey.survivaloverhaul.config.JsonFileName;
import icey.survivaloverhaul.config.JsonTypeToken;
import icey.survivaloverhaul.config.json.JsonConfig;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public class JsonConfigRegistration {
    public static final JsonItemIdentity DEFAULT_ITEM_IDENTITY = new JsonItemIdentity(null);

    public static void init(File configDir) {
        JsonConfigRegistration.registerTemperatures(configDir);
        JsonConfigRegistration.processAllJson(configDir);
    }

    public static void registerTemperatures(File configDir) {
        JsonConfig.registerBlockTemperature("minecraft:campfire", 7.5f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerBlockTemperature("minecraft:soul_campfire", 5.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerBlockTemperature("minecraft:campfire", 0.0f, new JsonPropertyValue("lit", "false"));
        JsonConfig.registerBlockTemperature("minecraft:soul_campfire", 0.0f, new JsonPropertyValue("lit", "false"));
        JsonConfig.registerBlockTemperature("minecraft:torch", 1.5f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature("minecraft:soul_torch", 0.75f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature("minecraft:wall_torch", 1.5f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature("minecraft:soul_wall_torch", 0.75f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature("minecraft:fire", 5.0f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature("minecraft:soul_fire", 2.5f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature("minecraft:furnace", 5.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerBlockTemperature("minecraft:blast_furnace", 5.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerBlockTemperature("minecraft:smoker", 5.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerBlockTemperature("minecraft:furnace", 0.0f, new JsonPropertyValue("lit", "false"));
        JsonConfig.registerBlockTemperature("minecraft:blast_furnace", 0.0f, new JsonPropertyValue("lit", "false"));
        JsonConfig.registerBlockTemperature("minecraft:smoker", 0.0f, new JsonPropertyValue("false", "true"));
        JsonConfig.registerBlockTemperature("survivaloverhaul:cooling_coil", -10.0f, new JsonPropertyValue("powered", "true"));
        JsonConfig.registerBlockTemperature("survivaloverhaul:heating_coil", 10.0f, new JsonPropertyValue("powered", "true"));
        JsonConfig.registerBlockTemperature("survivaloverhaul:cooling_coil", 0.0f, new JsonPropertyValue("powered", "false"));
        JsonConfig.registerBlockTemperature("survivaloverhaul:heating_coil", 0.0f, new JsonPropertyValue("powered", "false"));
        JsonConfig.registerBlockTemperature("minecraft:magma_block", 7.5f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature("minecraft:jack_o_lantern", 3.0f, new JsonPropertyValue[0]);
        JsonConfig.registerFluidTemperature("minecraft:lava", 10.0f);
        JsonConfig.registerFluidTemperature("minecraft:flowing_lava", 10.0f);
        JsonConfig.registerArmorTemperature("survivaloverhaul:snow_boots", 0.5f);
        JsonConfig.registerArmorTemperature("survivaloverhaul:snow_leggings", 2.5f);
        JsonConfig.registerArmorTemperature("survivaloverhaul:snow_chestplate", 3.0f);
        JsonConfig.registerArmorTemperature("survivaloverhaul:snow_helmet", 1.5f);
        JsonConfig.registerArmorTemperature("survivaloverhaul:desert_boots", -0.5f);
        JsonConfig.registerArmorTemperature("survivaloverhaul:desert_leggings", -2.5f);
        JsonConfig.registerArmorTemperature("survivaloverhaul:desert_chestplate", -3.0f);
        JsonConfig.registerArmorTemperature("survivaloverhaul:desert_helmet", -1.5f);
        JsonConfig.registerArmorTemperature("minecraft:leather_boots", 0.25f, 0.9f);
        JsonConfig.registerArmorTemperature("minecraft:leather_leggings", 0.75f, 0.9f);
        JsonConfig.registerArmorTemperature("minecraft:leather_chestplate", 1.0f, 0.9f);
        JsonConfig.registerArmorTemperature("minecraft:leather_helmet", 0.5f, 0.9f);
        JsonConfig.registerArmorTemperature("minecraft:iron_boots", 0.0f, 1.2f);
        JsonConfig.registerArmorTemperature("minecraft:iron_leggings", 0.0f, 1.2f);
        JsonConfig.registerArmorTemperature("minecraft:iron_chestplate", 0.0f, 1.2f);
        JsonConfig.registerArmorTemperature("minecraft:iron_helmet", 0.0f, 1.2f);
        JsonConfig.registerConsumableTemperature(TemporaryModifierGroup.FOOD.group(), "minecraft:mushroom_stew", 1.0f, 1200, DEFAULT_ITEM_IDENTITY);
        JsonConfig.registerConsumableTemperature(TemporaryModifierGroup.FOOD.group(), "minecraft:rabbit_stew", 1.0f, 1200, DEFAULT_ITEM_IDENTITY);
        JsonConfig.registerBiomeOverride("minecraft:crimson_forest", 0.75f, false);
        JsonConfig.registerBiomeOverride("minecraft:warped_forest", 0.75f, false);
        JsonConfig.registerBiomeOverride("minecraft:nether_wastes", 1.0f, false);
        JsonConfig.registerBiomeOverride("minecraft:soul_sand_valley", 1.0f, false);
        JsonConfig.registerBiomeOverride("minecraft:basalt_deltas", 1.45f, false);
        CompatController.initCompat();
    }

    public static void clearContainers() {
        JsonConfig.armorTemperatures.clear();
        JsonConfig.blockTemperatures.clear();
        JsonConfig.fluidTemperatures.clear();
        JsonConfig.biomeOverrides.clear();
        JsonConfig.consumableTemperature.clear();
    }

    public static void processAllJson(File jsonDir) {
        Map<String, List<JsonConsumableTemperature>> map;
        Map<String, JsonBiomeIdentity> map2;
        Map<String, JsonTemperature> map3;
        Map<String, List<JsonPropertyTemperature>> jsonBlockTemperatures;
        Map<String, List<JsonArmorIdentity>> jsonArmorTemperatures = JsonConfigRegistration.processJson(JsonFileName.ARMOR, JsonConfig.armorTemperatures, jsonDir, true);
        if (jsonArmorTemperatures != null) {
            Main.LOGGER.debug("Loaded " + jsonArmorTemperatures.size() + " armor temperature values from JSON");
            for (Map.Entry<String, List<JsonArmorIdentity>> entry : jsonArmorTemperatures.entrySet()) {
                for (JsonArmorIdentity jsonArmorIdentity : entry.getValue()) {
                    if (jsonArmorIdentity.identity != null) {
                        jsonArmorIdentity.identity.tryPopulateCompound();
                    }
                    JsonConfig.registerArmorTemperature(entry.getKey(), jsonArmorIdentity.temperature, jsonArmorIdentity.insulation, jsonArmorIdentity.identity == null ? DEFAULT_ITEM_IDENTITY : jsonArmorIdentity.identity);
                }
            }
        }
        if ((jsonBlockTemperatures = JsonConfigRegistration.processJson(JsonFileName.BLOCK, JsonConfig.blockTemperatures, jsonDir, true)) != null) {
            Main.LOGGER.debug("Loaded " + jsonBlockTemperatures.size() + " block temperature values from JSON");
            for (Map.Entry<String, List<JsonPropertyTemperature>> entry : jsonBlockTemperatures.entrySet()) {
                for (JsonPropertyTemperature jsonPropertyTemperature : entry.getValue()) {
                    JsonConfig.registerBlockTemperature(entry.getKey(), jsonPropertyTemperature.temperature, jsonPropertyTemperature.getAsPropertyArray());
                }
            }
            try {
                JsonConfigRegistration.manuallyWriteToJson(JsonFileName.BLOCK, JsonConfig.blockTemperatures, jsonDir);
            }
            catch (Exception exception) {
                Main.LOGGER.error("Error writing merged JSON file", (Throwable)exception);
            }
        }
        if ((map3 = JsonConfigRegistration.processJson(JsonFileName.LIQUID, JsonConfig.fluidTemperatures, jsonDir, true)) != null) {
            Main.LOGGER.debug("Loaded " + map3.size() + " fluid temperature values from JSON");
            for (Map.Entry<String, JsonTemperature> entry : map3.entrySet()) {
                JsonConfig.registerFluidTemperature(entry.getKey(), entry.getValue().temperature);
            }
            try {
                JsonConfigRegistration.manuallyWriteToJson(JsonFileName.LIQUID, JsonConfig.fluidTemperatures, jsonDir);
            }
            catch (Exception exception) {
                Main.LOGGER.error("Error writing merged JSON file", (Throwable)exception);
            }
        }
        if ((map2 = JsonConfigRegistration.processJson(JsonFileName.BIOME, JsonConfig.biomeOverrides, jsonDir, true)) != null) {
            Main.LOGGER.debug("Loaded " + map2.size() + " biome temperature overrides from JSON");
            for (Map.Entry<String, JsonBiomeIdentity> entry : map2.entrySet()) {
                JsonConfig.registerBiomeOverride(entry.getKey(), entry.getValue().temperature, entry.getValue().isDry);
            }
            try {
                JsonConfigRegistration.manuallyWriteToJson(JsonFileName.BIOME, JsonConfig.biomeOverrides, jsonDir);
            }
            catch (Exception exception) {
                Main.LOGGER.error("Error writing merged JSON file", (Throwable)exception);
            }
        }
        if ((map = JsonConfigRegistration.processJson(JsonFileName.CONSUMABLE, JsonConfig.consumableTemperature, jsonDir, true)) != null) {
            Main.LOGGER.debug("Loaded " + map.size() + " consumable temperature values from JSON");
            for (Map.Entry<String, List<JsonConsumableTemperature>> entry : map.entrySet()) {
                for (JsonConsumableTemperature jct : entry.getValue()) {
                    if (jct.identity != null) {
                        jct.identity.tryPopulateCompound();
                    }
                    JsonConfig.registerConsumableTemperature(jct.group, entry.getKey(), jct.temperature, jct.duration, jct.identity);
                }
            }
            try {
                JsonConfigRegistration.manuallyWriteToJson(JsonFileName.CONSUMABLE, JsonConfig.consumableTemperature, jsonDir);
            }
            catch (Exception exception) {
                Main.LOGGER.error("Error writing merged JSON file", (Throwable)exception);
            }
        }
    }

    @Nullable
    public static <T> T processJson(JsonFileName jfn, T container, File jsonDir, boolean forMerging) {
        try {
            return JsonConfigRegistration.processUncaughtJson(jfn, container, jsonDir, forMerging);
        }
        catch (Exception e) {
            Main.LOGGER.error("Error managing JSON file: " + jfn.get(), (Throwable)e);
            if (forMerging) {
                return null;
            }
            return container;
        }
    }

    @Nullable
    public static <T> T processUncaughtJson(JsonFileName jfn, T container, File jsonDir, boolean forMerging) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        File jsonFile = new File(jsonDir, jsonFileName);
        if (jsonFile.exists()) {
            Gson gson = JsonConfigRegistration.buildNewGson();
            return (T)gson.fromJson((Reader)new FileReader(jsonFile), type);
        }
        Gson gson = JsonConfigRegistration.buildNewGson();
        FileUtils.write((File)jsonFile, (CharSequence)gson.toJson(container, type), (String)null);
        if (forMerging) {
            return null;
        }
        return container;
    }

    private static <T> void manuallyWriteToJson(JsonFileName jfn, T container, File jsonDir) throws Exception {
        JsonConfigRegistration.manuallyWriteToJson(jfn, container, jsonDir, false);
    }

    private static <T> void manuallyWriteToJson(JsonFileName jfn, T container, File jsonDir, boolean forceWrite) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        Gson gson = JsonConfigRegistration.buildNewGson();
        File jsonFile = new File(jsonDir, jsonFileName);
        if (jsonFile.exists()) {
            Main.LOGGER.debug(jsonFile.getName() + " already exists!");
            if (forceWrite) {
                Main.LOGGER.debug("Overriding...");
            } else {
                return;
            }
        }
        FileUtils.write((File)jsonFile, (CharSequence)gson.toJson(container, type), (String)null);
    }

    private static Gson buildNewGson() {
        return new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    }
}

