/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.network.packets;

import icey.survivaloverhaul.Main;
import icey.survivaloverhaul.common.capability.heartmods.HeartModifierCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateHeartsPacket {
    private CompoundNBT compound;

    public UpdateHeartsPacket(INBT compound) {
        this.compound = (CompoundNBT)compound;
    }

    public UpdateHeartsPacket() {
    }

    public static UpdateHeartsPacket decode(PacketBuffer buffer) {
        return new UpdateHeartsPacket((INBT)buffer.func_150793_b());
    }

    public static void encode(UpdateHeartsPacket message, PacketBuffer buffer) {
        buffer.func_150786_a(message.compound);
    }

    public static void handle(UpdateHeartsPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> UpdateHeartsPacket.syncHearts(message.compound)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncHearts(final CompoundNBT compound) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                HeartModifierCapability hearts = (HeartModifierCapability)player.getCapability(Main.HEART_MOD_CAP).orElse((Object)new HeartModifierCapability());
                hearts.readNBT(compound);
                hearts.updateMaxHealth(player.func_130014_f_(), (PlayerEntity)player);
            }
        };
    }
}

