/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.network.packets;

import icey.survivaloverhaul.Main;
import icey.survivaloverhaul.common.capability.temperature.TemperatureCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateTemperaturesPacket {
    private CompoundNBT compound;

    public UpdateTemperaturesPacket(INBT compound) {
        this.compound = (CompoundNBT)compound;
    }

    public UpdateTemperaturesPacket() {
    }

    public static UpdateTemperaturesPacket decode(PacketBuffer buffer) {
        return new UpdateTemperaturesPacket((INBT)buffer.func_150793_b());
    }

    public static void encode(UpdateTemperaturesPacket message, PacketBuffer buffer) {
        buffer.func_150786_a(message.compound);
    }

    public static void handle(UpdateTemperaturesPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> UpdateTemperaturesPacket.syncTemperature(message.compound)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperature(final CompoundNBT compound) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                TemperatureCapability temperature = (TemperatureCapability)player.getCapability(Main.TEMPERATURE_CAP).orElse((Object)new TemperatureCapability());
                temperature.readNBT(compound);
            }
        };
    }
}

