/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.network.packets;

import icey.survivaloverhaul.Main;
import icey.survivaloverhaul.common.capability.wetness.WetnessCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateWetnessPacket {
    private CompoundNBT compound;

    public UpdateWetnessPacket(INBT compound) {
        this.compound = (CompoundNBT)compound;
    }

    public UpdateWetnessPacket() {
    }

    public static UpdateWetnessPacket decode(PacketBuffer buffer) {
        return new UpdateWetnessPacket((INBT)buffer.func_150793_b());
    }

    public static void encode(UpdateWetnessPacket message, PacketBuffer buffer) {
        buffer.func_150786_a(message.compound);
    }

    public static void handle(UpdateWetnessPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> UpdateWetnessPacket.syncWetness(message.compound)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncWetness(final CompoundNBT compound) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                WetnessCapability wetness = (WetnessCapability)player.getCapability(Main.WETNESS_CAP).orElse((Object)new WetnessCapability());
                wetness.readNBT(compound);
            }
        };
    }
}

