/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.util;

import icey.survivaloverhaul.api.temperature.TemperatureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class WorldUtil {
    private WorldUtil() {
    }

    public static BlockPos getSidedBlockPos(World world, Entity entity) {
        if (!world.field_72995_K) {
            return entity.func_233580_cy_();
        }
        if (entity instanceof PlayerEntity) {
            return new BlockPos(entity.func_213303_ch().func_72441_c(0.0, 0.5, 0.0));
        }
        if (entity instanceof ItemFrameEntity) {
            return new BlockPos(entity.func_213303_ch().func_72441_c(0.0, -0.45, 0.0));
        }
        return entity.func_233580_cy_();
    }

    public static boolean isChunkLoaded(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return true;
        }
        return ((ServerWorld)world).func_72863_F().func_73149_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static int calculateClientWorldEntityTemperature(World world, Entity entity) {
        return TemperatureUtil.clampTemperature(TemperatureUtil.getWorldTemperature(world, WorldUtil.getSidedBlockPos(world, entity)));
    }
}

