/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul.util.internal;

import icey.survivaloverhaul.api.temperature.DynamicModifierBase;
import icey.survivaloverhaul.api.temperature.ITemperatureUtil;
import icey.survivaloverhaul.api.temperature.ModifierBase;
import icey.survivaloverhaul.api.temperature.TemperatureEnum;
import icey.survivaloverhaul.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TemperatureUtilInternal
implements ITemperatureUtil {
    private final String TEMPERATURE_TAG = "ArmorTemp";

    @Override
    public int getPlayerTargetTemperature(PlayerEntity player) {
        float sum = 0.0f;
        World world = player.func_130014_f_();
        BlockPos pos = WorldUtil.getSidedBlockPos(world, (Entity)player);
        for (ModifierBase modifier : GameRegistry.findRegistry(ModifierBase.class).getValues()) {
            sum += modifier.getWorldInfluence(world, pos);
            sum += modifier.getPlayerInfluence(player);
        }
        for (DynamicModifierBase dynamicModifier : GameRegistry.findRegistry(DynamicModifierBase.class).getValues()) {
            sum += dynamicModifier.applyDynamicWorldInfluence(world, pos, sum);
            sum += dynamicModifier.applyDynamicPlayerInfluence(player, sum);
        }
        return Math.round(sum);
    }

    @Override
    public int getWorldTemperature(World world, BlockPos pos) {
        float sum = 0.0f;
        for (ModifierBase modifier : GameRegistry.findRegistry(ModifierBase.class).getValues()) {
            sum += modifier.getWorldInfluence(world, pos);
        }
        for (DynamicModifierBase dynamicModifier : GameRegistry.findRegistry(DynamicModifierBase.class).getValues()) {
            sum += dynamicModifier.applyDynamicWorldInfluence(world, pos, sum);
        }
        return (int)sum;
    }

    @Override
    public int clampTemperature(int temperature) {
        return MathHelper.func_76125_a((int)temperature, (int)TemperatureEnum.FROSTBITE.getLowerBound(), (int)TemperatureEnum.HEAT_STROKE.getUpperBound());
    }

    @Override
    public TemperatureEnum getTemperatureEnum(int temp) {
        for (TemperatureEnum tempEnum : TemperatureEnum.values()) {
            if (!tempEnum.matches(temp)) continue;
            return tempEnum;
        }
        if (temp < 0) {
            return TemperatureEnum.FROSTBITE;
        }
        return TemperatureEnum.HEAT_STROKE;
    }

    @Override
    public void setArmorTemperatureTag(ItemStack stack, float temperature) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT compound = stack.func_77978_p();
        compound.func_74776_a("ArmorTemp", temperature);
    }

    @Override
    public float getArmorTemperatureTag(ItemStack stack) {
        CompoundNBT compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("ArmorTemp")) {
            float tempTag = compound.func_74760_g("ArmorTemp");
            return tempTag;
        }
        return 0.0f;
    }

    @Override
    public void removeArmorTemperatureTag(ItemStack stack) {
        CompoundNBT compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("ArmorTemp")) {
            compound.func_82580_o("ArmorTemp");
        }
    }
}

