/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.ProperFacingBlock;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.modcompat.BuzzierBeesRedirection;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzDimension;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class HoneycombBrood
extends ProperFacingBlock {
    private static final ResourceLocation HONEY_TREAT = new ResourceLocation("productivebees:honey_treat");
    public static final IntegerProperty STAGE = BlockStateProperties.field_208168_U;

    public HoneycombBrood() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_151676_q).func_200944_c().func_200948_a(0.5f, 0.5f).func_200947_a(SoundType.field_211383_n).func_226897_b_(0.8f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176387_N, (Comparable)Direction.SOUTH)).func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176387_N, STAGE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)context.func_196000_l().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState thisBlockState, World world, BlockPos position, PlayerEntity playerEntity, Hand playerHand, BlockRayTraceResult raytraceResult) {
        ItemStack itemstack = playerEntity.func_184586_b(playerHand);
        if (itemstack.func_77973_b() == Items.field_151069_bo) {
            world.func_180501_a(position, (BlockState)((Block)BzBlocks.EMPTY_HONEYCOMB_BROOD.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, thisBlockState.func_177229_b((Property)BlockStateProperties.field_208155_H)), 3);
            int stage = (Integer)thisBlockState.func_177229_b((Property)STAGE);
            HoneycombBrood.spawnBroodMob(world, thisBlockState, position, stage);
            world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (!playerEntity.func_184812_l_()) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)Items.field_226638_pX_));
                } else if (!playerEntity.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_226638_pX_))) {
                    playerEntity.func_71019_a(new ItemStack((IItemProvider)Items.field_226638_pX_), false);
                }
            }
            if ((playerEntity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BzBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && !playerEntity.func_184812_l_() && !playerEntity.func_175149_v() && Bumblezone.BzBeeAggressionConfig.aggressiveBees.get().booleanValue()) {
                if (playerEntity.func_70644_a((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                    playerEntity.func_195063_d((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get());
                } else {
                    playerEntity.func_195064_c(new EffectInstance((Effect)BzEffects.WRATH_OF_THE_HIVE.get(), Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzBeeAggressionConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (itemstack.func_77973_b() == Items.field_226638_pX_ || itemstack.func_77973_b() == BzItems.SUGAR_WATER_BOTTLE.get()) {
            if (!world.field_72995_K) {
                boolean successfulGrowth = false;
                if (itemstack.func_77973_b() == BzItems.SUGAR_WATER_BOTTLE.get()) {
                    if (world.field_73012_v.nextFloat() < 0.3f) {
                        successfulGrowth = true;
                    }
                } else {
                    successfulGrowth = true;
                }
                if (successfulGrowth && world.field_73012_v.nextFloat() < 0.3f && !playerEntity.func_70644_a((Effect)BzEffects.WRATH_OF_THE_HIVE.get())) {
                    playerEntity.func_195064_c(new EffectInstance((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get(), (int)((float)Bumblezone.BzBeeAggressionConfig.howLongProtectionOfTheHiveLasts.get().intValue() * 0.75f), 1, false, false, true));
                }
                if (successfulGrowth) {
                    int stage = (Integer)thisBlockState.func_177229_b((Property)STAGE);
                    if (stage == 3) {
                        HoneycombBrood.spawnBroodMob(world, thisBlockState, position, stage);
                    } else {
                        world.func_175656_a(position, (BlockState)thisBlockState.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)));
                    }
                }
            }
            world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_191241_J, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (!playerEntity.func_184812_l_()) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)Items.field_151069_bo));
                } else if (!playerEntity.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151069_bo))) {
                    playerEntity.func_71019_a(new ItemStack((IItemProvider)Items.field_151069_bo), false);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (ModChecker.productiveBeesPresent && Bumblezone.BzModCompatibilityConfig.allowHoneyTreatCompat.get().booleanValue() && itemstack.func_77973_b().getRegistryName().equals((Object)HONEY_TREAT)) {
            if (!world.field_72995_K) {
                int stage = (Integer)thisBlockState.func_177229_b((Property)STAGE);
                if (stage == 3) {
                    HoneycombBrood.spawnBroodMob(world, thisBlockState, position, stage);
                } else {
                    int stageIncrease = world.field_73012_v.nextFloat() < 0.2f ? 2 : 1;
                    world.func_175656_a(position, (BlockState)thisBlockState.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(Math.min(3, stage + stageIncrease))));
                }
            }
            world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_191241_J, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (!playerEntity.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
        } else if (ModChecker.buzzierBeesPresent && Bumblezone.BzModCompatibilityConfig.allowHoneyWandCompat.get().booleanValue()) {
            ActionResultType action = BuzzierBeesRedirection.honeyWandTakingHoney(itemstack, thisBlockState, world, position, playerEntity, playerHand);
            if (action == ActionResultType.SUCCESS) {
                world.func_180501_a(position, (BlockState)((Block)BzBlocks.EMPTY_HONEYCOMB_BROOD.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, thisBlockState.func_177229_b((Property)BlockStateProperties.field_208155_H)), 3);
                int stage = (Integer)thisBlockState.func_177229_b((Property)STAGE);
                HoneycombBrood.spawnBroodMob(world, thisBlockState, position, stage);
                world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_226135_eP_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if ((world.func_234923_W_().equals(BzDimension.BZ_WORLD_KEY) || Bumblezone.BzBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && !playerEntity.func_184812_l_() && !playerEntity.func_175149_v() && Bumblezone.BzBeeAggressionConfig.aggressiveBees.get().booleanValue()) {
                    playerEntity.func_195064_c(new EffectInstance((Effect)BzEffects.WRATH_OF_THE_HIVE.get(), Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzBeeAggressionConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
                }
                return action;
            }
            action = BuzzierBeesRedirection.honeyWandGivingHoney(itemstack, thisBlockState, world, position, playerEntity, playerHand);
            if (action == ActionResultType.SUCCESS) {
                world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_226135_eP_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                int stage = (Integer)thisBlockState.func_177229_b((Property)STAGE);
                if (stage == 3) {
                    HoneycombBrood.spawnBroodMob(world, thisBlockState, position, stage);
                } else {
                    world.func_175656_a(position, (BlockState)thisBlockState.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)));
                }
                return action;
            }
        }
        return super.func_225533_a_(thisBlockState, world, position, playerEntity, playerHand, raytraceResult);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos position, Random rand) {
        super.func_225534_a_(state, world, position, rand);
        if (!world.func_175707_a(position, position)) {
            return;
        }
        List nearbyEntities = world.func_175647_a(LivingEntity.class, new AxisAlignedBB(position).func_186662_g((double)WrathOfTheHiveEffect.NEARBY_WRATH_EFFECT_RADIUS), entity -> ((LivingEntity)entity).func_70644_a((Effect)BzEffects.WRATH_OF_THE_HIVE.get()));
        int stage = (Integer)state.func_177229_b((Property)STAGE);
        if (stage < 3) {
            if (!nearbyEntities.isEmpty() || (world.func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) ? rand.nextInt(10) == 0 : rand.nextInt(22) == 0)) {
                world.func_180501_a(position, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)), 2);
            }
        } else if (Bumblezone.BzBlockMechanicsConfig.broodBlocksBeeSpawnCapacity.get() != 0) {
            if (!nearbyEntities.isEmpty() && (float)GeneralUtils.getEntityCountInBz() < (float)Bumblezone.BzBlockMechanicsConfig.broodBlocksBeeSpawnCapacity.get().intValue() * 1.75f) {
                HoneycombBrood.spawnBroodMob((World)world, state, position, stage);
            } else if (GeneralUtils.getEntityCountInBz() < Bumblezone.BzBlockMechanicsConfig.broodBlocksBeeSpawnCapacity.get()) {
                HoneycombBrood.spawnBroodMob((World)world, state, position, stage);
            }
        }
    }

    public void func_176208_a(World world, BlockPos position, BlockState state, PlayerEntity playerEntity) {
        ListNBT listOfEnchants = playerEntity.func_184614_ca().func_77986_q();
        if (listOfEnchants.stream().noneMatch(enchant -> enchant.func_150285_a_().contains("minecraft:silk_touch"))) {
            BlockState blockState = world.func_180495_p(position);
            int stage = (Integer)blockState.func_177229_b((Property)STAGE);
            if (stage == 3) {
                HoneycombBrood.spawnBroodMob(world, blockState, position, stage);
            }
            if ((playerEntity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BzBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && !playerEntity.func_184812_l_() && !playerEntity.func_175149_v() && Bumblezone.BzBeeAggressionConfig.aggressiveBees.get().booleanValue()) {
                if (playerEntity.func_70644_a((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                    playerEntity.func_195063_d((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get());
                } else {
                    playerEntity.func_195064_c(new EffectInstance((Effect)BzEffects.WRATH_OF_THE_HIVE.get(), Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzBeeAggressionConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
                }
            }
        }
        super.func_176208_a(world, position, state, playerEntity);
    }

    private static void spawnBroodMob(World world, BlockState state, BlockPos position, int stage) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        blockpos.func_189536_c(((Direction)state.func_177229_b((Property)field_176387_N)).func_176734_d());
        if (stage == 3 && !world.func_180495_p((BlockPos)blockpos).func_185904_a().func_76220_a()) {
            MobEntity beeMob = (MobEntity)EntityType.field_226289_e_.func_200721_a(world);
            beeMob.func_82227_f(true);
            HoneycombBrood.spawnMob(world, blockpos, beeMob, beeMob);
            if (world.field_73012_v.nextFloat() < 0.1f) {
                MobEntity honeySlimeMob = (MobEntity)((EntityType)BzEntities.HONEY_SLIME.get()).func_200721_a(world);
                honeySlimeMob.func_82227_f(true);
                HoneycombBrood.spawnMob(world, blockpos, beeMob, honeySlimeMob);
            }
            world.func_175656_a(position, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(0)));
        }
    }

    private static void spawnMob(World world, BlockPos.Mutable blockpos, MobEntity beeMob, MobEntity entity) {
        if (entity == null || world.field_72995_K) {
            return;
        }
        entity.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, world.func_201674_k().nextFloat() * 360.0f, 0.0f);
        if (ForgeHooks.canEntitySpawn((MobEntity)entity, (IWorld)world, (double)((double)blockpos.func_177958_n() + 0.5), (double)((double)blockpos.func_177956_o() + 0.5), (double)((double)blockpos.func_177952_p() + 0.5), null, (SpawnReason)SpawnReason.TRIGGERED) != -1) {
            entity.func_213386_a((IServerWorld)world, world.func_175649_E(new BlockPos(beeMob.func_213303_ch())), SpawnReason.TRIGGERED, null, null);
            world.func_217376_c((Entity)entity);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((Property)STAGE) + 1;
    }

    public void func_180655_c(BlockState blockState, World world, BlockPos position, Random random) {
        for (int i = 0; i < random.nextInt(2); ++i) {
            this.spawnHoneyParticles(world, position, blockState);
        }
        int stage = (Integer)blockState.func_177229_b((Property)STAGE);
        float soundVolume = 0.05f + (float)stage * 0.1f;
        if (world.field_73012_v.nextInt(20) == 0) {
            world.func_184134_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, SoundEvents.field_226127_ab_, SoundCategory.BLOCKS, soundVolume, 1.0f, true);
        }
    }

    private void spawnHoneyParticles(World world, BlockPos position, BlockState blockState) {
        VoxelShape currentBlockShape;
        double yEndHeight;
        if (blockState.func_204520_s().func_206888_e() && world.field_73012_v.nextFloat() < 0.08f && (yEndHeight = (currentBlockShape = blockState.func_196952_d((IBlockReader)world, position)).func_197758_c(Direction.Axis.Y)) >= 1.0 && !blockState.func_235714_a_((ITag)BlockTags.field_211923_H)) {
            double yStartHeight = currentBlockShape.func_197762_b(Direction.Axis.Y);
            if (yStartHeight > 0.0) {
                this.addHoneyParticle(world, position, currentBlockShape, (double)position.func_177956_o() + yStartHeight - 0.05);
            } else {
                BlockPos belowBlockpos = position.func_177977_b();
                BlockState belowBlockstate = world.func_180495_p(belowBlockpos);
                VoxelShape belowBlockShape = belowBlockstate.func_196952_d((IBlockReader)world, belowBlockpos);
                double yEndHeight2 = belowBlockShape.func_197758_c(Direction.Axis.Y);
                if ((yEndHeight2 < 1.0 || !belowBlockstate.func_200015_d((IBlockReader)world, belowBlockpos)) && belowBlockstate.func_204520_s().func_206888_e()) {
                    this.addHoneyParticle(world, position, currentBlockShape, (double)position.func_177956_o() - 0.05);
                }
            }
        }
    }

    private void addHoneyParticle(World world, BlockPos blockPos, VoxelShape blockShape, double height) {
        this.addHoneyParticle(world, (double)blockPos.func_177958_n() + blockShape.func_197762_b(Direction.Axis.X), (double)blockPos.func_177958_n() + blockShape.func_197758_c(Direction.Axis.X), (double)blockPos.func_177952_p() + blockShape.func_197762_b(Direction.Axis.Z), (double)blockPos.func_177952_p() + blockShape.func_197758_c(Direction.Axis.Z), height);
    }

    private void addHoneyParticle(World world, double xMin, double xMax, double zMax, double zMin, double yHeight) {
        world.func_195594_a((IParticleData)ParticleTypes.field_229427_ag_, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)xMin, (double)xMax), yHeight, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)zMax, (double)zMin), 0.0, 0.0, 0.0);
    }
}

