/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class BzContainerShapelessRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();
    private String group;

    public BzContainerShapelessRecipeBuilder(IItemProvider itemProvider, int count) {
        this.result = itemProvider.func_199767_j();
        this.count = count;
    }

    public static BzContainerShapelessRecipeBuilder shapeless(IItemProvider itemProvider) {
        return new BzContainerShapelessRecipeBuilder(itemProvider, 1);
    }

    public static BzContainerShapelessRecipeBuilder shapeless(IItemProvider itemProvider, int count) {
        return new BzContainerShapelessRecipeBuilder(itemProvider, count);
    }

    public BzContainerShapelessRecipeBuilder requires(ITag<Item> tag) {
        return this.requires(Ingredient.func_199805_a(tag));
    }

    public BzContainerShapelessRecipeBuilder requires(IItemProvider itemProvider) {
        return this.requires(itemProvider, 1);
    }

    public BzContainerShapelessRecipeBuilder requires(IItemProvider itemProvider, int count) {
        for (int i = 0; i < count; ++i) {
            this.requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemProvider}));
        }
        return this;
    }

    public BzContainerShapelessRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public BzContainerShapelessRecipeBuilder requires(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public BzContainerShapelessRecipeBuilder unlockedBy(String critera, ICriterionInstance criterionInstance) {
        this.advancement.func_200275_a(critera, criterionInstance);
        return this;
    }

    public BzContainerShapelessRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public void save(Consumer<IFinishedRecipe> recipeConsumer) {
        this.save(recipeConsumer, Registry.field_212630_s.func_177774_c((Object)this.result));
    }

    public void save(Consumer<IFinishedRecipe> recipeConsumer, String identifier) {
        ResourceLocation resourcelocation = Registry.field_212630_s.func_177774_c((Object)this.result);
        if (new ResourceLocation(identifier).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shapeless Recipe " + identifier + " should remove its 'save' argument");
        }
        this.save(recipeConsumer, new ResourceLocation(identifier));
    }

    public void save(Consumer<IFinishedRecipe> recipeConsumer, ResourceLocation resourceLocation) {
        this.ensureValid(resourceLocation);
        this.advancement.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)resourceLocation)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)resourceLocation)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        recipeConsumer.accept(new Result(resourceLocation, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement, new ResourceLocation(resourceLocation.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + resourceLocation.func_110623_a())));
    }

    private void ensureValid(ResourceLocation resourceLocation) {
        if (this.advancement.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation p_i48268_1_, Item p_i48268_2_, int p_i48268_3_, String p_i48268_4_, List<Ingredient> p_i48268_5_, Advancement.Builder p_i48268_6_, ResourceLocation p_i48268_7_) {
            this.id = p_i48268_1_;
            this.result = p_i48268_2_;
            this.count = p_i48268_3_;
            this.group = p_i48268_4_;
            this.ingredients = p_i48268_5_;
            this.advancement = p_i48268_6_;
            this.advancementId = p_i48268_7_;
        }

        public void func_218610_a(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.func_200304_c());
            }
            jsonObject.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)jsonobject);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)BzItems.CONTAINER_CRAFTING_RECIPE.get();
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancement.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

