/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ForgeSmeltingRecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    private final int resultCount;
    private String group;
    private final CookingRecipeSerializer<?> serializer;

    private ForgeSmeltingRecipeBuilder(Ingredient ingredient, IItemProvider resultItem, int resultCount, float experience, int cookTime) {
        this.result = resultItem.func_199767_j();
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookTime;
        this.resultCount = resultCount;
        this.serializer = IRecipeSerializer.field_222171_o;
    }

    public static ForgeSmeltingRecipeBuilder smelting(Ingredient ingredient, IItemProvider resultItem, int resultCount, float experience, int cookTime) {
        return new ForgeSmeltingRecipeBuilder(ingredient, resultItem, resultCount, experience, cookTime);
    }

    public ForgeSmeltingRecipeBuilder unlockedBy(String p_218628_1_, ICriterionInstance p_218628_2_) {
        return this;
    }

    public void save(Consumer<IFinishedRecipe> consumer) {
        this.save(consumer, Registry.field_212630_s.func_177774_c((Object)this.result));
    }

    public void save(Consumer<IFinishedRecipe> consumer, String identifier) {
        ResourceLocation resourcelocation1 = new ResourceLocation(identifier);
        ResourceLocation resourcelocation = Registry.field_212630_s.func_177774_c((Object)this.result);
        if (resourcelocation1.equals((Object)resourcelocation)) {
            throw new IllegalStateException("Recipe " + resourcelocation1 + " should remove its 'save' argument");
        }
        this.save(consumer, resourcelocation1);
    }

    public void save(Consumer<IFinishedRecipe> consumer, ResourceLocation resourceLocation) {
        consumer.accept(new Result(resourceLocation, this.group == null ? "" : this.group, this.ingredient, this.result, this.resultCount, this.experience, this.cookingTime, null, null, (IRecipeSerializer<? extends AbstractCookingRecipe>)this.serializer));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Item result;
        private final float experience;
        private final int cookingTime;
        private final int resultCount;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final IRecipeSerializer<? extends AbstractCookingRecipe> serializer;

        public Result(ResourceLocation id, String group, Ingredient ingredient, Item result, int resultCount, float experience, int cookTime, Advancement.Builder advancement, ResourceLocation advancementId, IRecipeSerializer<? extends AbstractCookingRecipe> recipeSerializer) {
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.experience = experience;
            this.cookingTime = cookTime;
            this.resultCount = resultCount;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.serializer = recipeSerializer;
        }

        public void func_218610_a(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            jsonObject.add("ingredient", this.ingredient.func_200304_c());
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
            resultObject.addProperty("count", (Number)this.resultCount);
            jsonObject.add("result", (JsonElement)resultObject);
            jsonObject.addProperty("experience", (Number)Float.valueOf(this.experience));
            jsonObject.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

