/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.effects;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.modcompat.CarrierBeeRedirection;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class WrathOfTheHiveEffect
extends Effect {
    public static final EntityPredicate SEE_THROUGH_WALLS = new EntityPredicate().func_221014_c();
    public static final EntityPredicate LINE_OF_SIGHT = new EntityPredicate();
    public static boolean ACTIVE_WRATH = false;
    public static int NEARBY_WRATH_EFFECT_RADIUS = 8;

    public WrathOfTheHiveEffect(EffectType type, int potionColor) {
        super(type, potionColor);
    }

    public boolean func_76403_b() {
        return true;
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration >= 1;
    }

    public void func_76394_a(LivingEntity entity, int amplifier) {
        World world = entity.field_70170_p;
        if (amplifier >= 2) {
            WrathOfTheHiveEffect.unBEElievablyHighAggression(world, entity);
            if ((float)GeneralUtils.getEntityCountInBz() < (float)Bumblezone.BzBlockMechanicsConfig.broodBlocksBeeSpawnCapacity.get().intValue() * 3.0f && !world.func_201670_d() && world.field_73012_v.nextFloat() <= 0.0045f) {
                BlockPos spawnBlockPos = new BlockPos(entity.func_226277_ct_() + (double)((world.field_73012_v.nextInt(30) + 10) * (world.field_73012_v.nextBoolean() ? 1 : -1)), entity.func_226278_cu_() + (double)((world.field_73012_v.nextInt(30) + 10) * (world.field_73012_v.nextBoolean() ? 1 : -1)), entity.func_226281_cx_() + (double)((world.field_73012_v.nextInt(30) + 10) * (world.field_73012_v.nextBoolean() ? 1 : -1)));
                if (world.func_180495_p(spawnBlockPos).func_185904_a() != Material.field_151579_a) {
                    return;
                }
                if (ModChecker.carrierBeesPresent && world.field_73012_v.nextBoolean()) {
                    CarrierBeeRedirection.CBMobSpawn(entity, spawnBlockPos);
                } else {
                    BeeEntity bee = (BeeEntity)EntityType.field_226289_e_.func_200721_a(world);
                    if (bee == null) {
                        return;
                    }
                    bee.func_70012_b((double)spawnBlockPos.func_177958_n() + 0.5, (double)spawnBlockPos.func_177956_o() + 0.5, (double)spawnBlockPos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    bee.func_213386_a((IServerWorld)world, world.func_175649_E(spawnBlockPos), SpawnReason.TRIGGERED, null, null);
                    ForgeHooks.canEntitySpawn((MobEntity)bee, (IWorld)world, (double)((double)spawnBlockPos.func_177958_n() + 0.5), (double)((double)spawnBlockPos.func_177956_o() + 0.5), (double)((double)spawnBlockPos.func_177952_p() + 0.5), null, (SpawnReason)SpawnReason.TRIGGERED);
                    world.func_217376_c((Entity)bee);
                }
            }
        } else {
            WrathOfTheHiveEffect.mediumAggression(world, entity);
        }
        if (!world.func_201670_d()) {
            for (int attempts = 0; attempts < 5; ++attempts) {
                int range = NEARBY_WRATH_EFFECT_RADIUS * 2;
                BlockPos selectedBlockToGrow = new BlockPos(entity.func_226277_ct_() + (double)(world.field_73012_v.nextInt(range) - NEARBY_WRATH_EFFECT_RADIUS), entity.func_226278_cu_() + (double)(world.field_73012_v.nextInt(range) - NEARBY_WRATH_EFFECT_RADIUS), entity.func_226281_cx_() + (double)(world.field_73012_v.nextInt(range) - NEARBY_WRATH_EFFECT_RADIUS));
                BlockState state = world.func_180495_p(selectedBlockToGrow);
                if (!(state.func_177230_c() instanceof HoneycombBrood)) continue;
                state.func_227033_a_((ServerWorld)world, selectedBlockToGrow, world.field_73012_v);
            }
        }
    }

    public static void mediumAggression(World world, LivingEntity livingEntity) {
        WrathOfTheHiveEffect.setAggression(world, livingEntity, BeeEntity.class, LINE_OF_SIGHT, Math.max(Bumblezone.BzBeeAggressionConfig.speedBoostLevel.get() - 1, 1), Math.max((Bumblezone.BzBeeAggressionConfig.absorptionBoostLevel.get() - 1) / 2, 1), Math.max((Bumblezone.BzBeeAggressionConfig.strengthBoostLevel.get() - 1) / 3, 1));
        if (ModChecker.carrierBeesPresent) {
            WrathOfTheHiveEffect.setAggression(world, livingEntity, CarrierBeeRedirection.CBGetAppleBeeClass(), LINE_OF_SIGHT, Math.max(Bumblezone.BzBeeAggressionConfig.speedBoostLevel.get() - 1, 1), Math.max((Bumblezone.BzBeeAggressionConfig.absorptionBoostLevel.get() - 1) / 2, 1), Math.max((Bumblezone.BzBeeAggressionConfig.strengthBoostLevel.get() - 1) / 3, 1));
        }
    }

    public static void unBEElievablyHighAggression(World world, LivingEntity livingEntity) {
        WrathOfTheHiveEffect.setAggression(world, livingEntity, BeeEntity.class, SEE_THROUGH_WALLS, Bumblezone.BzBeeAggressionConfig.speedBoostLevel.get() - 1, Bumblezone.BzBeeAggressionConfig.absorptionBoostLevel.get() - 1, Bumblezone.BzBeeAggressionConfig.strengthBoostLevel.get() - 1);
        if (ModChecker.carrierBeesPresent) {
            WrathOfTheHiveEffect.setAggression(world, livingEntity, CarrierBeeRedirection.CBGetAppleBeeClass(), SEE_THROUGH_WALLS, Bumblezone.BzBeeAggressionConfig.speedBoostLevel.get() - 1, Bumblezone.BzBeeAggressionConfig.absorptionBoostLevel.get() - 1, Bumblezone.BzBeeAggressionConfig.strengthBoostLevel.get() - 1);
        }
    }

    private static void setAggression(World world, LivingEntity livingEntity, Class<? extends MobEntity> entityToFind, EntityPredicate sightMode, int speed, int absorption, int strength) {
        if (livingEntity instanceof BeeEntity || ModChecker.carrierBeesPresent && CarrierBeeRedirection.CBGetAppleBeeClass().isInstance(livingEntity)) {
            return;
        }
        sightMode.func_221013_a((double)Bumblezone.BzBeeAggressionConfig.aggressionTriggerRadius.get().intValue());
        List beeList = world.func_217374_a(entityToFind, sightMode, livingEntity, livingEntity.func_174813_aQ().func_186662_g((double)Bumblezone.BzBeeAggressionConfig.aggressionTriggerRadius.get().intValue()));
        for (MobEntity bee : beeList) {
            EffectInstance effect;
            bee.func_70624_b(livingEntity);
            if (bee instanceof IAngerable) {
                ((IAngerable)bee).func_230260_a__(20);
                ((IAngerable)bee).func_230259_a_(livingEntity.func_110124_au());
            }
            if ((effect = livingEntity.func_70660_b((Effect)BzEffects.WRATH_OF_THE_HIVE.get())) == null) continue;
            int leftoverDuration = effect.func_76459_b();
            bee.func_195064_c(new EffectInstance(Effects.field_76424_c, leftoverDuration, speed, false, false));
            bee.func_195064_c(new EffectInstance(Effects.field_76444_x, leftoverDuration, absorption, false, false));
            bee.func_195064_c(new EffectInstance(Effects.field_76420_g, leftoverDuration, strength, false, true));
        }
    }

    public static void calmTheBees(World world, LivingEntity livingEntity) {
        WrathOfTheHiveEffect.clearAggression(world, livingEntity, BeeEntity.class, SEE_THROUGH_WALLS);
        if (ModChecker.carrierBeesPresent) {
            WrathOfTheHiveEffect.clearAggression(world, livingEntity, CarrierBeeRedirection.CBGetAppleBeeClass(), SEE_THROUGH_WALLS);
        }
    }

    private static void clearAggression(World world, LivingEntity livingEntity, Class<? extends MobEntity> entityToFind, EntityPredicate sightMode) {
        sightMode.func_221013_a((double)Bumblezone.BzBeeAggressionConfig.aggressionTriggerRadius.get().intValue() * 0.5);
        List beeList = world.func_217374_a(entityToFind, sightMode, livingEntity, livingEntity.func_174813_aQ().func_186662_g((double)Bumblezone.BzBeeAggressionConfig.aggressionTriggerRadius.get().intValue() * 0.5));
        for (MobEntity bee : beeList) {
            if (bee.func_70638_az() != livingEntity) continue;
            bee.func_70624_b(null);
            bee.func_213395_q(false);
            bee.func_195063_d(Effects.field_76420_g);
            bee.func_195063_d(Effects.field_76424_c);
            bee.func_195063_d(Effects.field_76444_x);
            if (!(bee instanceof BeeEntity)) continue;
            ((BeeEntity)bee).func_230260_a__(0);
        }
    }

    public void func_111187_a(LivingEntity entity, AttributeModifierManager attributes, int amplifier) {
        if (BeeAggression.doesBeesHateEntity((Entity)entity)) {
            entity.func_195064_c(new EffectInstance((Effect)BzEffects.WRATH_OF_THE_HIVE.get(), Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 1, false, true));
        } else {
            super.func_111187_a(entity, attributes, amplifier);
        }
    }
}

