/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ResourcefulBeesRedirection;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CombCutterEnchantment
extends Enchantment {
    private static final Lazy<Set<Block>> TARGET_BLOCKS = Lazy.of(() -> {
        HashSet validBlocks = new HashSet();
        ForgeRegistries.BLOCKS.getEntries().forEach(entry -> {
            if (((RegistryKey)entry.getKey()).func_240901_a_().func_110623_a().contains("comb")) {
                validBlocks.add(entry.getValue());
            }
        });
        return validBlocks;
    });
    private static final Lazy<Set<Block>> LESSER_TARGET_BLOCKS = Lazy.of(() -> {
        HashSet validBlocks = new HashSet();
        ForgeRegistries.BLOCKS.getEntries().forEach(entry -> {
            String path = ((RegistryKey)entry.getKey()).func_240901_a_().func_110623_a();
            if (entry.getValue() instanceof BeehiveBlock || path.contains("hive") || path.contains("nest") || path.contains("wax") && !path.contains("waxed")) {
                validBlocks.add(entry.getValue());
            }
        });
        return validBlocks;
    });

    public CombCutterEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentType.VANISHABLE, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public Set<Block> getTargetBlocks() {
        return (Set)TARGET_BLOCKS.get();
    }

    public Set<Block> getLesserTargetBlocks() {
        return (Set)LESSER_TARGET_BLOCKS.get();
    }

    public static void attemptFasterMining(PlayerEvent.BreakSpeed event) {
        if (((CombCutterEnchantment)BzEnchantments.COMB_CUTTER.get()).getTargetBlocks().contains(event.getState().func_177230_c())) {
            CombCutterEnchantment.mineFaster(event, false);
        } else if (((CombCutterEnchantment)BzEnchantments.COMB_CUTTER.get()).getLesserTargetBlocks().contains(event.getState().func_177230_c())) {
            CombCutterEnchantment.mineFaster(event, true);
        }
    }

    private static void mineFaster(PlayerEvent.BreakSpeed event, boolean lesserTarget) {
        float breakSpeed = event.getNewSpeed();
        PlayerEntity playerEntity = event.getPlayer();
        ItemStack itemStack = playerEntity.func_184614_ca();
        int equipmentLevel = EnchantmentHelper.func_185284_a((Enchantment)((Enchantment)BzEnchantments.COMB_CUTTER.get()), (LivingEntity)playerEntity);
        if (equipmentLevel > 0 && !itemStack.func_190926_b()) {
            breakSpeed += (float)(equipmentLevel * equipmentLevel + (lesserTarget ? 3 : 13));
        }
        event.setNewSpeed(breakSpeed);
    }

    public static void increasedCombDrops(PlayerEntity playerEntity, World world, BlockPos pos) {
        ItemStack itemStack = playerEntity.func_184614_ca();
        int equipmentLevel = EnchantmentHelper.func_185284_a((Enchantment)((Enchantment)BzEnchantments.COMB_CUTTER.get()), (LivingEntity)playerEntity);
        if (equipmentLevel > 0 && !itemStack.func_190926_b()) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_226635_pU_, equipmentLevel * 3));
        }
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_92089_a(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof ShearsItem || item instanceof SwordItem || ModChecker.resourcefulBeesPresent && ResourcefulBeesRedirection.isRBComb(item);
    }
}

