/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.client.MusicHandler;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.tags.BZBlockTags;
import com.telepathicgrunt.the_bumblezone.tags.BZItemTags;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.logging.log4j.Level;

public class BeeAggression {
    private static final Set<EntityType<?>> SET_OF_BEE_HATED_ENTITIES = new HashSet();

    public static void setupBeeHatingList(World world) {
        if (SET_OF_BEE_HATED_ENTITIES.size() != 0) {
            return;
        }
        for (EntityType entityType : Registry.field_212629_r) {
            Entity entity;
            if (entityType.func_220339_d() != EntityClassification.MONSTER && entityType.func_220339_d() != EntityClassification.CREATURE && entityType.func_220339_d() != EntityClassification.AMBIENT) continue;
            try {
                entity = entityType.func_200721_a(world);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.log(Level.WARN, "Failed to temporary create " + Registry.field_212629_r.func_177774_c((Object)entityType) + " mob in order to check if it is an arthropod that bees should be naturally angry at. Will check if mob is a bear or wasp in its name instead. Error message is: " + e.getMessage());
                String mobName = Registry.field_212629_r.func_177774_c((Object)entityType).toString();
                if (!mobName.contains("bear") && !mobName.contains("wasp")) continue;
                SET_OF_BEE_HATED_ENTITIES.add(entityType);
                continue;
            }
            if (!(entity instanceof MobEntity)) continue;
            String mobName = Registry.field_212629_r.func_177774_c((Object)entityType).toString();
            MobEntity mobEntity = (MobEntity)entity;
            if ((mobEntity.func_70668_bt() != CreatureAttribute.field_223224_c_ || mobName.contains("bee")) && !(mobEntity instanceof PandaEntity) && !mobName.contains("bear") && !mobName.contains("wasp")) continue;
            SET_OF_BEE_HATED_ENTITIES.add(entityType);
        }
    }

    public static void minedBlockAnger(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        BlockState blockState = event.getState();
        if (BZBlockTags.WRATH_ACTIVATING_BLOCKS_WHEN_MINED.func_230235_a_((Object)blockState.func_177230_c())) {
            BeeAggression.angerBees(player);
        }
    }

    public static void pickupItemAnger(PlayerEvent.ItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        Item item = event.getStack().func_77973_b();
        if (BZItemTags.WRATH_ACTIVATING_ITEMS_WHEN_PICKED_UP.func_230235_a_((Object)item)) {
            BeeAggression.angerBees(player);
        }
    }

    private static void angerBees(PlayerEntity player) {
        if (!(player instanceof FakePlayer) && (player.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BzBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && Bumblezone.BzBeeAggressionConfig.aggressiveBees.get().booleanValue() && !player.func_184812_l_() && !player.func_175149_v()) {
            if (player.func_70644_a((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                player.func_195063_d((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get());
            } else {
                player.func_195064_c(new EffectInstance((Effect)BzEffects.WRATH_OF_THE_HIVE.get(), Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzBeeAggressionConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
            }
        }
    }

    public static void beeHitAndAngered(Entity entity, Entity attackerEntity) {
        if (!entity.field_70170_p.field_72995_K && (entity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BzBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && Bumblezone.BzBeeAggressionConfig.aggressiveBees.get().booleanValue() && entity instanceof BeeEntity && attackerEntity != null) {
            if (attackerEntity instanceof PlayerEntity && !((PlayerEntity)attackerEntity).func_184812_l_() && !attackerEntity.func_175149_v()) {
                PlayerEntity player = (PlayerEntity)attackerEntity;
                if (player.func_70644_a((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                    player.func_195063_d((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get());
                    WrathOfTheHiveEffect.calmTheBees(player.field_70170_p, (LivingEntity)player);
                } else {
                    player.func_195064_c(new EffectInstance((Effect)BzEffects.WRATH_OF_THE_HIVE.get(), Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzBeeAggressionConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
                }
            } else if (attackerEntity instanceof MobEntity) {
                MobEntity mob = (MobEntity)attackerEntity;
                if (mob.func_70644_a((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                    mob.func_195063_d((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get());
                    WrathOfTheHiveEffect.calmTheBees(mob.field_70170_p, (LivingEntity)mob);
                } else {
                    mob.func_195064_c(new EffectInstance((Effect)BzEffects.WRATH_OF_THE_HIVE.get(), Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, true));
                }
            }
        }
    }

    public static void entityTypeBeeAnger(Entity entity) {
        if (BeeAggression.doesBeesHateEntity(entity)) {
            ((MobEntity)entity).func_195064_c(new EffectInstance((Effect)BzEffects.WRATH_OF_THE_HIVE.get(), Bumblezone.BzBeeAggressionConfig.howLongWrathOfTheHiveLasts.get().intValue(), 1, false, true));
        }
    }

    public static boolean doesBeesHateEntity(Entity entity) {
        if (!entity.field_70170_p.field_72995_K && entity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) && Bumblezone.BzBeeAggressionConfig.aggressiveBees.get().booleanValue() && entity instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)entity;
            return SET_OF_BEE_HATED_ENTITIES.contains(entity.func_200600_R()) && !mobEntity.func_70644_a((Effect)BzEffects.WRATH_OF_THE_HIVE.get());
        }
        return false;
    }

    public static void playerTick(PlayerEntity playerEntity) {
        if (!playerEntity.field_70170_p.func_201670_d() && playerEntity.func_70644_a((Effect)BzEffects.WRATH_OF_THE_HIVE.get()) && !Bumblezone.BzBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue() && !playerEntity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            playerEntity.func_195063_d((Effect)BzEffects.WRATH_OF_THE_HIVE.get());
            WrathOfTheHiveEffect.calmTheBees(playerEntity.field_70170_p, (LivingEntity)playerEntity);
        }
        if (playerEntity.field_70170_p.func_201670_d()) {
            boolean wrathEffect = playerEntity.func_70644_a((Effect)BzEffects.WRATH_OF_THE_HIVE.get());
            if (wrathEffect) {
                MusicHandler.playAngryBeeMusic(playerEntity);
            }
            if (!WrathOfTheHiveEffect.ACTIVE_WRATH && wrathEffect) {
                WrathOfTheHiveEffect.ACTIVE_WRATH = true;
            } else if (WrathOfTheHiveEffect.ACTIVE_WRATH && !wrathEffect) {
                MusicHandler.stopAngryBeeMusic(playerEntity);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.field_70170_p, (LivingEntity)playerEntity);
                WrathOfTheHiveEffect.ACTIVE_WRATH = false;
            }
        }
    }
}

