/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.tags.BZItemTags;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeInteractivity {
    private static final ResourceLocation STICKY_HONEY_WAND = new ResourceLocation("buzzier_bees:sticky_honey_wand");

    public static void beeFeeding(World world, PlayerEntity playerEntity, Hand hand, Entity target) {
        if (!world.field_72995_K && target instanceof BeeEntity) {
            BeeEntity beeEntity = (BeeEntity)target;
            ItemStack itemstack = playerEntity.func_184586_b(hand);
            ResourceLocation itemRL = itemstack.func_77973_b().getRegistryName();
            if (itemRL == null || !BZItemTags.BEE_FEEDING_ITEMS.func_230235_a_((Object)itemstack.func_77973_b())) {
                return;
            }
            if (ModChecker.buzzierBeesPresent && itemRL.equals((Object)STICKY_HONEY_WAND) && Bumblezone.BzModCompatibilityConfig.allowHoneyWandCompat.get().booleanValue()) {
                beeEntity.func_195064_c(new EffectInstance(Effects.field_76432_h, 1, 1, false, false, false));
                BeeInteractivity.calmAndSpawnHearts(world, playerEntity, beeEntity, 0.2f, 3);
                BeeInteractivity.consumeItem(playerEntity, hand, itemstack, (Item)ForgeRegistries.ITEMS.getValue(STICKY_HONEY_WAND));
            } else {
                if (itemRL.func_110623_a().contains("honey")) {
                    beeEntity.func_195064_c(new EffectInstance(Effects.field_76432_h, 1, 2, false, false, false));
                    BeeInteractivity.calmAndSpawnHearts(world, playerEntity, beeEntity, 0.3f, 3);
                } else {
                    beeEntity.func_195064_c(new EffectInstance(Effects.field_76432_h, 1, 1, false, false, false));
                    BeeInteractivity.calmAndSpawnHearts(world, playerEntity, beeEntity, 0.1f, 3);
                }
                if (!playerEntity.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                    if (itemRL.func_110623_a().contains("bowl") && !itemstack.func_77973_b().equals(Items.field_151054_z)) {
                        BeeInteractivity.givePlayerContainer(playerEntity, hand, itemstack, Items.field_151054_z);
                    } else if (itemRL.func_110623_a().contains("bucket") && !itemstack.func_77973_b().equals(Items.field_151133_ar)) {
                        BeeInteractivity.givePlayerContainer(playerEntity, hand, itemstack, Items.field_151054_z);
                    } else if (itemRL.func_110623_a().contains("bottle") && !itemstack.func_77973_b().equals(Items.field_151069_bo)) {
                        BeeInteractivity.givePlayerContainer(playerEntity, hand, itemstack, Items.field_151069_bo);
                    }
                }
                playerEntity.func_226292_a_(hand, true);
            }
        }
    }

    private static void calmAndSpawnHearts(World world, PlayerEntity playerEntity, BeeEntity beeEntity, float calmChance, int hearts) {
        boolean calmed;
        boolean bl = calmed = world.field_73012_v.nextFloat() < calmChance;
        if (calmed) {
            if (playerEntity.func_70644_a((Effect)BzEffects.WRATH_OF_THE_HIVE.get())) {
                playerEntity.func_195063_d((Effect)BzEffects.WRATH_OF_THE_HIVE.get());
                WrathOfTheHiveEffect.calmTheBees(playerEntity.field_70170_p, (LivingEntity)playerEntity);
            } else {
                playerEntity.func_195064_c(new EffectInstance((Effect)BzEffects.PROTECTION_OF_THE_HIVE.get(), Bumblezone.BzBeeAggressionConfig.howLongProtectionOfTheHiveLasts.get().intValue(), 2, false, false, true));
            }
        }
        if (!beeEntity.func_233678_J__() || calmed) {
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197633_z, beeEntity.func_226277_ct_(), beeEntity.func_226278_cu_(), beeEntity.func_226281_cx_(), hearts, (double)world.func_201674_k().nextFloat() * 0.5 - 0.25, (double)(world.func_201674_k().nextFloat() * 0.2f + 0.2f), (double)world.func_201674_k().nextFloat() * 0.5 - 0.25, (double)world.func_201674_k().nextFloat() * 0.4 + (double)0.2f);
        }
    }

    private static void consumeItem(PlayerEntity playerEntity, Hand hand, ItemStack handItemstack, Item replacementItem) {
        if (!playerEntity.func_184812_l_()) {
            handItemstack.func_190918_g(1);
            BeeInteractivity.givePlayerContainer(playerEntity, hand, handItemstack, replacementItem);
        } else {
            playerEntity.func_226292_a_(hand, true);
        }
    }

    private static void givePlayerContainer(PlayerEntity playerEntity, Hand hand, ItemStack itemstack, Item itemToGive) {
        if (itemstack.func_190926_b()) {
            playerEntity.func_184611_a(hand, new ItemStack((IItemProvider)itemToGive));
        } else if (!playerEntity.field_71071_by.func_70441_a(new ItemStack((IItemProvider)itemToGive))) {
            playerEntity.func_71019_a(new ItemStack((IItemProvider)itemToGive), false);
        }
    }
}

