/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.capabilities.IPlayerPosAndDim;
import com.telepathicgrunt.the_bumblezone.capabilities.PlayerPositionAndDimension;
import com.telepathicgrunt.the_bumblezone.entities.PlayerTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.tags.BZBlockTags;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.Level;

public class PlayerTeleportationHookup {
    @CapabilityInject(value=IPlayerPosAndDim.class)
    public static Capability<IPlayerPosAndDim> PAST_POS_AND_DIM = null;

    public static void playerTick(PlayerEntity playerEntity) {
        PlayerPositionAndDimension cap;
        LazyOptional lazyOptionalCap;
        if (playerEntity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (playerEntity.func_226278_cu_() < -3.0) {
                playerEntity.func_226286_f_(playerEntity.func_226277_ct_(), -3.01, playerEntity.func_226281_cx_());
                playerEntity.field_70143_R = 0.0f;
                if (!playerEntity.field_70170_p.field_72995_K) {
                    PlayerTeleportationHookup.teleportOutOfBz(playerEntity);
                }
            } else if (playerEntity.func_226278_cu_() > 255.0) {
                playerEntity.func_226286_f_(playerEntity.func_226277_ct_(), 255.01, playerEntity.func_226281_cx_());
                if (!playerEntity.field_70170_p.field_72995_K) {
                    PlayerTeleportationHookup.teleportOutOfBz(playerEntity);
                }
            }
        } else if (!playerEntity.field_70170_p.field_72995_K && (lazyOptionalCap = playerEntity.getCapability(PAST_POS_AND_DIM)).isPresent() && (cap = (PlayerPositionAndDimension)lazyOptionalCap.orElseThrow(RuntimeException::new)).getTeleporting()) {
            PlayerTeleportationBackend.enteringBumblezone((Entity)playerEntity);
            cap.setTeleporting(false);
            PlayerTeleportationHookup.reAddStatusEffect(playerEntity);
        }
    }

    private static void teleportOutOfBz(PlayerEntity playerEntity) {
        if (!playerEntity.func_130014_f_().field_72995_K) {
            PlayerTeleportationHookup.checkAndCorrectStoredDimension(playerEntity);
            PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
            RegistryKey world_key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)cap.getNonBZDim());
            ServerWorld destination = playerEntity.func_130014_f_().func_73046_m().func_71218_a(world_key);
            if (destination == null) {
                destination = playerEntity.func_130014_f_().func_73046_m().func_71218_a(World.field_234918_g_);
            }
            PlayerTeleportationBackend.exitingBumblezone((Entity)playerEntity, destination);
            PlayerTeleportationHookup.reAddStatusEffect(playerEntity);
        }
    }

    public static boolean runEnderpearlImpact(Vector3d hitBlockPos, Entity thrower) {
        World world = thrower.field_70170_p;
        if (!(world.field_72995_K || !(thrower instanceof ServerPlayerEntity) || world.func_234923_W_().func_240901_a_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BzDimensionConfig.onlyOverworldHivesTeleports.get().booleanValue() && !world.func_234923_W_().equals(World.field_234918_g_))) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)thrower;
            BlockPos hivePos = new BlockPos(0, 0, 0);
            boolean hitHive = false;
            for (double offsetX = -0.99; offsetX <= 0.99; offsetX += 0.99) {
                block1: for (double offsetY = -0.99; offsetY <= 0.99; offsetY += 0.99) {
                    for (double offsetZ = -0.99; offsetZ <= 0.99; offsetZ += 0.99) {
                        BlockPos offsettedHitPos = new BlockPos(hitBlockPos.func_72441_c(offsetX, offsetY, offsetZ));
                        BlockState block = world.func_180495_p(offsettedHitPos);
                        if (!PlayerTeleportationBackend.isValidBeeHive(block)) continue;
                        hitHive = true;
                        hivePos = offsettedHitPos;
                        offsetX = 1.0;
                        offsetY = 1.0;
                        continue block1;
                    }
                }
            }
            boolean validBelowBlock = false;
            if (!BZBlockTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT.func_230236_b_().isEmpty()) {
                if (BZBlockTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT.func_230235_a_((Object)world.func_180495_p(hivePos.func_177977_b()).func_177230_c())) {
                    validBelowBlock = true;
                } else if (Bumblezone.BzDimensionConfig.warnPlayersOfWrongBlockUnderHive.get().booleanValue()) {
                    Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: the_bumblezone:required_blocks_under_hive_to_teleport tag does not have the block below the hive.");
                    StringTextComponent message = new StringTextComponent("the_bumblezone:required_blocks_under_hive_to_teleport tag does not have the block below the hive.");
                    playerEntity.func_146105_b((ITextComponent)message, true);
                    return false;
                }
            } else {
                validBelowBlock = true;
            }
            if (hitHive && validBelowBlock) {
                PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
                cap.setTeleporting(true);
                return true;
            }
        }
        return false;
    }

    private static void reAddStatusEffect(PlayerEntity playerEntity) {
        ArrayList effectInstanceList = new ArrayList(playerEntity.func_70651_bq());
        for (int i = effectInstanceList.size() - 1; i >= 0; --i) {
            EffectInstance effectInstance = (EffectInstance)effectInstanceList.get(i);
            if (effectInstance == null) continue;
            playerEntity.func_195063_d(effectInstance.func_188419_a());
            playerEntity.func_195064_c(new EffectInstance(effectInstance.func_188419_a(), effectInstance.func_76459_b(), effectInstance.func_76458_c(), effectInstance.func_82720_e(), effectInstance.func_188418_e(), effectInstance.func_205348_f()));
        }
    }

    private static void checkAndCorrectStoredDimension(PlayerEntity playerEntity) {
        PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
        if (cap.getNonBZDim().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BzDimensionConfig.forceExitToOverworld.get().booleanValue()) {
            cap.setNonBZDim(World.field_234918_g_.func_240901_a_());
        }
    }
}

