/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.controllers.HoneySlimeMoveHelperController;
import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;

public class TemptGoal
extends Goal {
    private static final EntityPredicate ENTITY_PREDICATE = new EntityPredicate().func_221013_a(10.0).func_221008_a().func_221011_b().func_221009_d().func_221014_c();
    protected final HoneySlimeEntity slime;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double rotationPitch;
    private double rotationYaw;
    protected PlayerEntity closestPlayer;
    private int delayTemptCounter;
    private final Ingredient temptItem;

    public TemptGoal(HoneySlimeEntity creatureIn, double speedIn, Ingredient temptItemsIn) {
        this.slime = creatureIn;
        this.temptItem = temptItemsIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(creatureIn.func_70661_as() instanceof GroundPathNavigator) && !(creatureIn.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.closestPlayer = this.slime.field_70170_p.func_217370_a(ENTITY_PREDICATE, (LivingEntity)this.slime);
        if (this.closestPlayer == null) {
            return false;
        }
        return this.isTempting(this.closestPlayer.func_184614_ca()) || this.isTempting(this.closestPlayer.func_184592_cb());
    }

    protected boolean isTempting(ItemStack stack) {
        return this.temptItem.test(stack);
    }

    public boolean func_75253_b() {
        if (this.isScaredByPlayerMovement()) {
            if (this.slime.func_70068_e((Entity)this.closestPlayer) < 36.0) {
                if (this.closestPlayer.func_70092_e(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.closestPlayer.field_70125_A - this.rotationPitch) > 5.0 || Math.abs((double)this.closestPlayer.field_70177_z - this.rotationYaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.closestPlayer.func_226277_ct_();
                this.targetY = this.closestPlayer.func_226278_cu_();
                this.targetZ = this.closestPlayer.func_226281_cx_();
            }
            this.rotationPitch = this.closestPlayer.field_70125_A;
            this.rotationYaw = this.closestPlayer.field_70177_z;
        }
        return this.func_75250_a();
    }

    protected boolean isScaredByPlayerMovement() {
        return false;
    }

    public void func_75249_e() {
        this.targetX = this.closestPlayer.func_226277_ct_();
        this.targetY = this.closestPlayer.func_226278_cu_();
        this.targetZ = this.closestPlayer.func_226281_cx_();
    }

    public void func_75251_c() {
        this.closestPlayer = null;
        this.slime.func_70661_as().func_75499_g();
        this.delayTemptCounter = 100;
    }

    public void func_75246_d() {
        this.slime.func_70671_ap().func_75651_a((Entity)this.closestPlayer, (float)(this.slime.func_184649_cE() + 20), (float)this.slime.func_70646_bf());
        if (this.slime.func_70068_e((Entity)this.closestPlayer) < 6.25) {
            this.slime.func_70661_as().func_75499_g();
        } else {
            this.slime.func_70625_a((Entity)this.closestPlayer, 10.0f, 10.0f);
            ((HoneySlimeMoveHelperController)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, true);
            ((HoneySlimeMoveHelperController)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }
}

