/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modcompat.BuzzierBeesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.CarrierBeesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.CharmCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.PokecubeCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.PotionOfBeesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ProductiveBeesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ResourcefulBeesCompat;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.Level;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ModChecker {
    public static boolean potionOfBeesPresent = false;
    public static boolean productiveBeesPresent = false;
    public static boolean carrierBeesPresent = false;
    public static boolean resourcefulBeesPresent = false;
    public static boolean buzzierBeesPresent = false;
    public static boolean pokecubePresent = false;
    public static boolean charmPresent = false;

    public static void setupModCompat() {
        String modid = "";
        try {
            modid = "potionofbees";
            ModChecker.loadupModCompat(modid, () -> PotionOfBeesCompat.setupPotionOfBees());
            modid = "carrierbees";
            ModChecker.loadupModCompat(modid, () -> CarrierBeesCompat.setupCarrierBees());
            modid = "resourcefulbees";
            ModChecker.loadupModCompat(modid, () -> ResourcefulBeesCompat.setupResourcefulBees());
            modid = "buzzier_bees";
            ModChecker.loadupModCompat(modid, () -> BuzzierBeesCompat.setupBuzzierBees());
            modid = "productivebees";
            if (ModChecker.isNotOutdated(modid, "0.5.1", true)) {
                ModChecker.loadupModCompat(modid, () -> ProductiveBeesCompat.setupProductiveBees());
            }
            modid = "pokecube_mobs";
            ModChecker.loadupModCompat(modid, () -> PokecubeCompat.setupPokecube());
            modid = "charm";
            ModChecker.loadupModCompat(modid, () -> CharmCompat.setupCharm());
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs("classloading " + modid + " and so, mod compat done afterwards broke");
            e.printStackTrace();
        }
    }

    private static void loadupModCompat(String modid, Runnable runnable) {
        try {
            if (ModList.get().isLoaded(modid)) {
                runnable.run();
            }
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs(modid);
            e.printStackTrace();
        }
    }

    private static void printErrorToLogs(String currentModID) {
        Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
        Bumblezone.LOGGER.log(Level.INFO, " ");
        Bumblezone.LOGGER.log(Level.INFO, "ERROR: Something broke when trying to add mod compatibility with " + currentModID + ". Please let The Bumblezone developer (TelepathicGrunt) know about this!");
        Bumblezone.LOGGER.log(Level.INFO, " ");
        Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
    }

    private static boolean isNotOutdated(String currentModID, String minVersion, boolean checkQualifierInstead) {
        if (!ModList.get().getModContainerById(currentModID).isPresent()) {
            return true;
        }
        IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById(currentModID).get()).getModInfo();
        ArtifactVersion modVersion = modInfo.getVersion();
        if (checkQualifierInstead && modVersion.getQualifier() != null) {
            modVersion = new DefaultArtifactVersion(modVersion.getQualifier());
        }
        if (modVersion.compareTo((Object)new DefaultArtifactVersion(minVersion)) < 0) {
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "BUMBLEZONE: You're using a version of " + modInfo.getDisplayName() + " that is outdated. Please update " + modInfo.getDisplayName() + " to the latest version of that mod to enable compat with Bumblezone again.");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            return false;
        }
        return true;
    }
}

