/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzFeatures;
import com.telepathicgrunt.the_bumblezone.tags.BZBlockTags;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ProductiveBeesCompat {
    private static final String PRODUCTIVE_BEES_NAMESPACE = "productivebees";
    private static final List<Block> ORE_BASED_HONEYCOMB_VARIANTS = new ArrayList<Block>();
    private static final List<Block> SPIDER_DUNGEON_HONEYCOMBS = new ArrayList<Block>();
    private static List<String> PRODUCTIVE_BEES_LIST = new ArrayList<String>();
    private static final Map<ResourceLocation, Block> PRODUCTIVE_BEES_HONEYCOMBS_MAP = new HashMap<ResourceLocation, Block>();
    private static final List<Pair<Block, ConfiguredFeature<?, ?>>> PRODUCTIVE_BEES_CFS = new ArrayList();

    public static void setupProductiveBees() {
        for (Map.Entry entry : Registry.field_212618_g.func_239659_c_()) {
            ResourceLocation rl = ((RegistryKey)entry.getKey()).func_240901_a_();
            if (!rl.func_110624_b().equals(PRODUCTIVE_BEES_NAMESPACE) || !rl.func_110623_a().contains("comb")) continue;
            PRODUCTIVE_BEES_HONEYCOMBS_MAP.put(((RegistryKey)entry.getKey()).func_240901_a_(), (Block)entry.getValue());
        }
        HashSet<Block> unusedHoneycombs = new HashSet<Block>(PRODUCTIVE_BEES_HONEYCOMBS_MAP.values());
        if (Bumblezone.BzModCompatibilityConfig.spawnProductiveBeesHoneycombVariants.get().booleanValue()) {
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_ROTTEN.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_BAUXITE.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_BRAZEN.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_BRONZE.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_COPPER.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_EXPERIENCE.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_FOSSILISED.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_BISMUTH.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_CINNABAR.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_SLIMY.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_OBSIDIAN.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_REFINED_OBSIDIAN.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_RADIOACTIVE.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_URANINITE.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_WITHERED.get());
            ProductiveBeesCompat.addToSpiderDungeonList(unusedHoneycombs, (Block)ModBlocks.COMB_NETHERITE.get());
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_GOLD.get(), 34, 3, 6, 230, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_IRON.get(), 26, 1, 30, 300, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_REDSTONE.get(), 22, 1, 30, 350, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_LAPIS.get(), 22, 1, -30, 60, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_EMERALD.get(), 10, 1, 6, 600, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_ENDER.get(), 10, 1, 200, 150, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_PROSPERITY.get(), 10, 1, 200, 400, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_EXPERIENCE.get(), 10, 1, -500, 500, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_DIAMOND.get(), 10, 1, 6, 40, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_NETHERITE.get(), 10, 1, 6, 1000, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_AMBER.get(), 34, 1, 40, 230, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_BLAZING.get(), 34, 1, 40, 230, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_BLITZ.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_BLIZZ.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_BONE.get(), 22, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_BRONZE.get(), 34, 1, 40, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_TINKERS_BRONZE.get(), 34, 1, 40, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_COBALT.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_CHOCOLATE.get(), 34, 1, 40, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_CONSTANTAN.get(), 34, 1, 40, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_COSMIC_DUST.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_DRACONIC.get(), 10, 1, 200, 450, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_DRACONIC.get(), 10, 1, -150, 180, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_ENDERIUM.get(), 10, 1, 200, 200, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_ENDER_BIOTITE.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_ENDER_BIOTITE.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_ELECTRUM.get(), 30, 1, 40, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_ELEMENTIUM.get(), 10, 1, 40, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_FOSSILISED.get(), 18, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_FLUORITE.get(), 18, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_FROSTY.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_GHOSTLY.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_GLOWING.get(), 34, 1, 40, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_HEPATIZON.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_HEPATIZON.get(), 10, 1, -120, 150, false);
            Block tempComb = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(PRODUCTIVE_BEES_NAMESPACE, "comb_ichor_slimy"));
            if (tempComb != null) {
                ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, tempComb, 34, 1, 6, 230, false);
            }
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_IMPERIUM.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_INFERIUM.get(), 10, 1, 2, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_INSANIUM.get(), 10, 1, 2, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_INVAR.get(), 10, 1, 2, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_KNIGHTSLIME.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_KNIGHTSLIME.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_LEADEN.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_LUMIUM.get(), 10, 1, 1, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_MAGMATIC.get(), 34, 1, 40, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_MANASTEEL.get(), 10, 1, -100, 135, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_MANYULLYN.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_MANYULLYN.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_MILKY.get(), 10, 1, 2, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_MENRIL.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_MENRIL.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_NICKEL.get(), 10, 1, -100, 135, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_OSMIUM.get(), 10, 1, -100, 135, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_PINK_SLIMY.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_PINK_SLIMY.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_PLASTIC.get(), 10, 1, 2, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_PLATINUM.get(), 10, 1, -100, 135, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_RARE_SALVAGE.get(), 10, 1, -150, 180, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_PRUDENTIUM.get(), 10, 1, 2, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_PIG_IRON.get(), 34, 1, 40, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_POWDERY.get(), 10, 1, 60, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_QUEENS_SLIME.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_QUEENS_SLIME.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_QUARTZ.get(), 10, 1, 60, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_REFINED_GLOWSTONE.get(), 25, 1, 60, 170, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SAPPHIRE.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SIGNALUM.get(), 10, 1, 1, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SILICON.get(), 10, 1, 1, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SILVER.get(), 10, 1, -100, 135, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SKY_SLIMY.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SLIMESTEEL.get(), 10, 1, -120, 150, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_STARMETAL.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SOULIUM.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SOULIUM.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SOULSTEEL.get(), 10, 1, 200, 400, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SOULSTEEL.get(), 10, 1, -120, 150, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SPECTRUM.get(), 34, 1, 40, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_STEEL.get(), 10, 1, 1, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_TEA.get(), 34, 1, 40, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_TERRASTEEL.get(), 10, 1, 1, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_TERTIUM.get(), 10, 1, 1, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_TIN.get(), 10, 1, 1, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_TITANIUM.get(), 10, 1, -100, 135, true);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_TINKERS_BRONZE.get(), 34, 1, 40, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_TUNGSTEN.get(), 10, 1, 1, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_ROSE_GOLD.get(), 34, 1, 40, 300, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_ZINC.get(), 10, 1, 1, 1000, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_ENDER_BIOTITE.get(), 10, 1, 1, 2500, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SUPREMIUM.get(), 10, 1, 1, 2500, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_SPACIAL.get(), 10, 1, 1, 2500, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_VIBRANIUM.get(), 10, 1, 1, 2500, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_ALLTHEMODIUM.get(), 10, 1, 1, 2500, false);
            ProductiveBeesCompat.addCombToWorldgen(unusedHoneycombs, (Block)ModBlocks.COMB_UNOBTAINIUM.get(), 10, 1, 1, 2500, false);
            for (Block remainingCombs : unusedHoneycombs) {
                ProductiveBeesCompat.addCombToWorldgen(null, remainingCombs, 10, 1, 1, 1000, false);
            }
        }
        ModChecker.productiveBeesPresent = true;
    }

    public static void PBAddWorldgen(List<Biome> bumblezoneBiomes) {
        HashMap PB_DATA = new HashMap(BeeReloadListener.INSTANCE.getData());
        PRODUCTIVE_BEES_LIST = new ArrayList(PB_DATA.keySet());
        Set blacklistedBees = Arrays.stream(Bumblezone.BzModCompatibilityConfig.PBBlacklistedBees.get().split(",")).map(String::trim).collect(Collectors.toSet());
        PRODUCTIVE_BEES_LIST.removeIf(blacklistedBees::contains);
        for (Biome biome : bumblezoneBiomes) {
            for (Pair<Block, ConfiguredFeature<?, ?>> cf : PRODUCTIVE_BEES_CFS) {
                if (BZBlockTags.BLACKLISTED_PRODUCTIVEBEES_COMBS.func_230235_a_(cf.getFirst())) continue;
                ((List)biome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal())).add(() -> cf.getSecond());
            }
        }
        SPIDER_DUNGEON_HONEYCOMBS.removeIf(arg_0 -> BZBlockTags.BLACKLISTED_PRODUCTIVEBEES_COMBS.func_230235_a_(arg_0));
        ORE_BASED_HONEYCOMB_VARIANTS.removeIf(arg_0 -> BZBlockTags.BLACKLISTED_PRODUCTIVEBEES_COMBS.func_230235_a_(arg_0));
    }

    private static void addToSpiderDungeonList(Set<Block> unusedHoneycombs, Block combBlock) {
        SPIDER_DUNGEON_HONEYCOMBS.add(combBlock);
        unusedHoneycombs.remove(combBlock);
    }

    private static void addCombToWorldgen(Set<Block> unusedHoneycombs, Block combBlock, int veinSize, int count, int bottomOffset, int range, boolean addToHoneycombList) {
        if (combBlock == null || combBlock == Blocks.field_150350_a) {
            return;
        }
        ResourceLocation blockRL = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)combBlock);
        String cfRL = "the_bumblezone:" + blockRL.func_110624_b() + blockRL.func_110623_a();
        int idOffset = 0;
        while (WorldGenRegistries.field_243653_e.func_241873_b(new ResourceLocation(cfRL + idOffset)).isPresent()) {
            ++idOffset;
        }
        ConfiguredFeature cf = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(BzFeatures.HONEYCOMB_BUMBLEZONE, combBlock.func_176223_P(), veinSize)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(bottomOffset, 0, range))).func_242728_a()).func_242731_b(count);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation(cfRL + idOffset), (Object)cf);
        PRODUCTIVE_BEES_CFS.add(Pair.of((Object)combBlock, (Object)cf));
        if (unusedHoneycombs != null) {
            unusedHoneycombs.remove(combBlock);
        }
        if (addToHoneycombList) {
            ORE_BASED_HONEYCOMB_VARIANTS.add(combBlock);
        }
    }

    public static boolean PBIsExpandedBeehiveBlock(BlockState block) {
        if (block.func_177230_c() instanceof ExpansionBox && block.func_177229_b((Property)AdvancedBeehive.EXPANDED) != VerticalHive.NONE) {
            return true;
        }
        if (BlockTags.func_199896_a().func_241834_b(new ResourceLocation("productivebees:solitary_overworld_nests")).func_230235_a_((Object)block.func_177230_c())) {
            return true;
        }
        return block.func_177230_c() instanceof AdvancedBeehiveAbstract;
    }

    public static void PBMobSpawnEvent(LivingSpawnEvent.CheckSpawn event, boolean isChild) {
        if (PRODUCTIVE_BEES_LIST.size() == 0) {
            Bumblezone.LOGGER.warn("Error! List of productive bees is empty! Cannot spawn their bees. Please let TelepathicGrunt (The Bumblezone dev) know about this!");
            return;
        }
        MobEntity entity = (MobEntity)event.getEntity();
        IServerWorld world = (IServerWorld)event.getWorld();
        ConfigurableBeeEntity productiveBeeEntity = (ConfigurableBeeEntity)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).func_200721_a(entity.field_70170_p);
        if (productiveBeeEntity == null) {
            return;
        }
        BlockPos.Mutable blockpos = new BlockPos.Mutable().func_189533_g((Vector3i)entity.func_233580_cy_());
        productiveBeeEntity.func_70012_b((double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.5f), (double)((float)blockpos.func_177952_p() + 0.5f), world.func_201674_k().nextFloat() * 360.0f, 0.0f);
        productiveBeeEntity.func_213386_a(world, world.func_175649_E(productiveBeeEntity.func_233580_cy_()), event.getSpawnReason(), null, null);
        productiveBeeEntity.setBeeType(PRODUCTIVE_BEES_LIST.get(world.func_201674_k().nextInt(PRODUCTIVE_BEES_LIST.size())));
        world.func_217376_c((Entity)productiveBeeEntity);
    }

    public static BlockState PBGetRottenedHoneycomb(Random random) {
        if (SPIDER_DUNGEON_HONEYCOMBS.size() == 0) {
            return Blocks.field_226908_md_.func_176223_P();
        }
        return SPIDER_DUNGEON_HONEYCOMBS.get(random.nextInt(random.nextInt(SPIDER_DUNGEON_HONEYCOMBS.size()) + 1)).func_176223_P();
    }

    public static BlockState PBGetRandomHoneycomb(Random random, int lowerBoundBias) {
        if (ORE_BASED_HONEYCOMB_VARIANTS.size() == 0) {
            return Blocks.field_226908_md_.func_176223_P();
        }
        int index = ORE_BASED_HONEYCOMB_VARIANTS.size() - 1;
        for (int i = 0; i < lowerBoundBias && index != 0; ++i) {
            index = random.nextInt(index + 1);
        }
        return ORE_BASED_HONEYCOMB_VARIANTS.get(index).func_176223_P();
    }
}

