/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.block.multiblocks.apiary.ApiaryBlock;
import com.resourcefulbees.resourcefulbees.block.multiblocks.apiary.ApiaryBreederBlock;
import com.resourcefulbees.resourcefulbees.block.multiblocks.apiary.ApiaryStorageBlock;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModBlocks;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.registry.ModVillagerProfessions;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzConfiguredFeatures;
import com.telepathicgrunt.the_bumblezone.modinit.BzFeatures;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.tags.BZBlockTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;

public class ResourcefulBeesCompat {
    private static final String RESOURCEFUL_BEES_NAMESPACE = "resourcefulbees";
    private static final List<EntityType<?>> RESOURCEFUL_BEES_LIST = new ArrayList();
    private static final Map<ResourceLocation, Block> RESOURCEFUL_HONEYCOMBS_MAP = new HashMap<ResourceLocation, Block>();
    private static final List<Block> ORE_BASED_HONEYCOMB_VARIANTS = new ArrayList<Block>();
    private static final List<Block> SPIDER_DUNGEON_HONEYCOMBS = new ArrayList<Block>();
    private static final List<Pair<Block, ConfiguredFeature<?, ?>>> RESOURCEFUL_BEES_CFS = new ArrayList();
    private static final List<Block> HONEY_BLOCKS = new ArrayList<Block>();

    public static void setupResourcefulBees() {
        HashMap<CustomBeeData, EntityType> tempBeeMap = new HashMap<CustomBeeData, EntityType>();
        BeeRegistry.getRegistry().getBees().forEach((s, b) -> {
            EntityType cfr_ignored_0 = (EntityType)tempBeeMap.put((CustomBeeData)b, (EntityType)ForgeRegistries.ENTITIES.getValue(b.getEntityTypeRegistryID()));
        });
        if (Bumblezone.BzModCompatibilityConfig.useSpawnInWorldConfigFromRB.get().booleanValue()) {
            tempBeeMap.forEach((b, e) -> {
                if (!b.getSpawnData().canSpawnInWorld()) {
                    tempBeeMap.remove(b);
                }
            });
        }
        if (Bumblezone.BzModCompatibilityConfig.useSpawnInWorldConfigFromRB.get().booleanValue()) {
            tempBeeMap.forEach((b, e) -> {
                if (!b.getSpawnData().getBiomeBlacklist().contains("the_bumblezone")) {
                    tempBeeMap.remove(b);
                }
            });
        }
        tempBeeMap.forEach((b, e) -> {
            Set blacklistedBees = Arrays.stream(Bumblezone.BzModCompatibilityConfig.RBBlacklistedBees.get().split(",")).map(String::trim).map(ResourceLocation::new).collect(Collectors.toSet());
            if (blacklistedBees.contains(e.getRegistryName())) {
                tempBeeMap.remove(b);
            }
        });
        tempBeeMap.forEach((b, e) -> {
            if (b.hasHoneycomb() && b.getCombBlockRegistryObject() != null) {
                RESOURCEFUL_HONEYCOMBS_MAP.put(b.getCombBlockRegistryObject().getId(), (Block)b.getCombBlockRegistryObject().get());
            }
            RESOURCEFUL_BEES_LIST.add((EntityType<?>)e);
        });
        for (Object entry : Registry.field_212618_g.func_239659_c_()) {
            ResourceLocation resourceLocation = ((RegistryKey)entry.getKey()).func_240901_a_();
            if (!resourceLocation.func_110624_b().equals(RESOURCEFUL_BEES_NAMESPACE)) continue;
            if (resourceLocation.func_110623_a().contains("honeycomb")) {
                RESOURCEFUL_HONEYCOMBS_MAP.put(((RegistryKey)entry.getKey()).func_240901_a_(), (Block)entry.getValue());
                continue;
            }
            if (!resourceLocation.func_110623_a().contains("honey") || !resourceLocation.func_110623_a().contains("block") || resourceLocation.func_110623_a().contains("comb") || resourceLocation.func_110623_a().contains("fluid")) continue;
            HONEY_BLOCKS.add((Block)entry.getValue());
        }
        HashMap<ResourceLocation, Block> unusedHoneycombs = new HashMap<ResourceLocation, Block>(RESOURCEFUL_HONEYCOMBS_MAP);
        if (Bumblezone.BzModCompatibilityConfig.spawnResourcefulBeesHoneycombVariants.get().booleanValue()) {
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "coal_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "coal_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "coal_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "iron_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "iron_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "zombie_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "zombie_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "pigman_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "pigman_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "skeleton_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "nether_quartz_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "creeper_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "creeper_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "wither_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "netherite_honeycomb_block"));
            ResourcefulBeesCompat.addToSpiderDungeonList(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "rgbee_honeycomb_block"));
            ResourcefulBeesCompat.addCombToWorldgen(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "gold_honeycomb_block"), 34, 3, 6, 230, true);
            ResourcefulBeesCompat.addCombToWorldgen(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "iron_honeycomb_block"), 26, 1, 30, 300, true);
            ResourcefulBeesCompat.addCombToWorldgen(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "redstone_honeycomb_block"), 22, 1, 30, 350, true);
            ResourcefulBeesCompat.addCombToWorldgen(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "lapis_honeycomb_block"), 22, 1, -30, 60, true);
            ResourcefulBeesCompat.addCombToWorldgen(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "emerald_honeycomb_block"), 10, 1, 6, 600, true);
            ResourcefulBeesCompat.addCombToWorldgen(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "ender_honeycomb_block"), 10, 1, 200, 150, true);
            ResourcefulBeesCompat.addCombToWorldgen(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "diamond_honeycomb_block"), 10, 1, 6, 400, true);
            ResourcefulBeesCompat.addCombToWorldgen(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "rgbee_honeycomb_block"), 10, 1, 6, 244, true);
            ResourcefulBeesCompat.addCombToWorldgen(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "dragon_honeycomb_block"), 10, 1, 200, 450, false);
            ResourcefulBeesCompat.addCombToWorldgen(unusedHoneycombs, new ResourceLocation(RESOURCEFUL_BEES_NAMESPACE, "dragon_honeycomb_block"), 10, 1, -150, 180, false);
            for (Map.Entry entry : unusedHoneycombs.entrySet()) {
                ResourcefulBeesCompat.addCombToWorldgen(null, (ResourceLocation)entry.getKey(), 10, 1, 1, 1000, false);
            }
        }
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.LOWEST, ResourcefulBeesCompat::setupResourcefulBeesTrades);
        ModChecker.resourcefulBeesPresent = true;
    }

    public static void setupResourcefulBeesTrades(VillagerTradesEvent event) {
        if (event.getType() == ModVillagerProfessions.BEEKEEPER.get()) {
            Int2ObjectMap trades = event.getTrades();
            ArrayList<GeneralUtils.BasicItemTrade> tradeList = new ArrayList<GeneralUtils.BasicItemTrade>((Collection)trades.get(2));
            tradeList.add(new GeneralUtils.BasicItemTrade(Items.field_151166_bC, 1, (Item)BzItems.STICKY_HONEY_RESIDUE.get(), 2));
            trades.put(2, tradeList);
            tradeList = new ArrayList((Collection)trades.get(3));
            tradeList.add(new GeneralUtils.BasicItemTrade((Item)BzItems.HONEY_CRYSTAL_SHARDS.get(), 3, Items.field_151166_bC, 1));
            trades.put(3, tradeList);
            tradeList = new ArrayList((Collection)trades.get(4));
            tradeList.add(new GeneralUtils.BasicItemTrade(Items.field_151166_bC, 2, (Item)BzItems.HONEY_CRYSTAL.get(), 1));
            trades.put(4, tradeList);
            tradeList = new ArrayList((Collection)trades.get(5));
            tradeList.add(new GeneralUtils.BasicItemTrade(Items.field_151166_bC, 20, (Item)BzItems.HONEYCOMB_LARVA.get(), 1));
            trades.put(5, tradeList);
        }
    }

    public static void RBAddWorldgen(List<Biome> bumblezone_biomes) {
        for (Biome biome : bumblezone_biomes) {
            if (Bumblezone.BzModCompatibilityConfig.RBBeesWaxWorldgen.get().booleanValue()) {
                ((List)biome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.VEGETAL_DECORATION.ordinal())).add(() -> BzConfiguredFeatures.BZ_BEES_WAX_PILLAR_CONFIGURED_FEATURE);
            }
            for (Pair<Block, ConfiguredFeature<?, ?>> cf : RESOURCEFUL_BEES_CFS) {
                if (BZBlockTags.BLACKLISTED_RESOURCEFUL_COMBS.func_230235_a_(cf.getFirst())) continue;
                ((List)biome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal())).add(() -> cf.getSecond());
            }
        }
        ORE_BASED_HONEYCOMB_VARIANTS.removeIf(arg_0 -> BZBlockTags.BLACKLISTED_RESOURCEFUL_COMBS.func_230235_a_(arg_0));
        SPIDER_DUNGEON_HONEYCOMBS.removeIf(arg_0 -> BZBlockTags.BLACKLISTED_RESOURCEFUL_COMBS.func_230235_a_(arg_0));
    }

    private static void addCombToWorldgen(Map<ResourceLocation, Block> unusedHoneycombs, ResourceLocation blockEntryRL, int veinSize, int count, int bottomOffset, int range, boolean addToBeeDungeon) {
        Block honeycomb = RESOURCEFUL_HONEYCOMBS_MAP.get(blockEntryRL);
        if (honeycomb == null) {
            return;
        }
        String cfRL = "the_bumblezone:" + blockEntryRL.func_110624_b() + blockEntryRL.func_110623_a();
        int idOffset = 0;
        while (WorldGenRegistries.field_243653_e.func_241873_b(new ResourceLocation(cfRL + idOffset)).isPresent()) {
            ++idOffset;
        }
        ConfiguredFeature cf = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(BzFeatures.HONEYCOMB_BUMBLEZONE, honeycomb.func_176223_P(), veinSize)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(bottomOffset, 0, range))).func_242728_a()).func_242731_b(count);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation(cfRL + idOffset), (Object)cf);
        RESOURCEFUL_BEES_CFS.add(Pair.of((Object)honeycomb, (Object)cf));
        if (addToBeeDungeon) {
            ORE_BASED_HONEYCOMB_VARIANTS.add(honeycomb);
        }
        if (unusedHoneycombs != null) {
            unusedHoneycombs.remove(blockEntryRL);
        }
    }

    private static void addToSpiderDungeonList(Map<ResourceLocation, Block> unusedHoneycombs, ResourceLocation blockEntryRL) {
        Block block = RESOURCEFUL_HONEYCOMBS_MAP.get(blockEntryRL);
        if (block != null) {
            SPIDER_DUNGEON_HONEYCOMBS.add(block);
        }
        unusedHoneycombs.remove(blockEntryRL);
    }

    public static boolean RBIsApairyBlock(BlockState block) {
        return block.func_177230_c() instanceof ApiaryBlock && (Boolean)block.func_177229_b((Property)ApiaryBlock.VALIDATED) != false || block.func_177230_c() instanceof ApiaryBreederBlock || block.func_177230_c() instanceof ApiaryStorageBlock;
    }

    public static BlockState getRBBeesWaxBlock() {
        return ((Block)ModBlocks.WAX_BLOCK.get()).func_176223_P();
    }

    public static BlockState getRBHoneyBlock(Random random) {
        return HONEY_BLOCKS.get(random.nextInt(random.nextInt(HONEY_BLOCKS.size()) + 1)).func_176223_P();
    }

    public static void RBMobSpawnEvent(LivingSpawnEvent.CheckSpawn event, boolean isChild) {
        if (RESOURCEFUL_BEES_LIST.size() == 0) {
            Bumblezone.LOGGER.warn("Error! List of Resourceful bees is empty! Cannot spawn their bees. Please let TelepathicGrunt (The Bumblezone dev) know about this!");
            return;
        }
        MobEntity entity = (MobEntity)event.getEntity();
        IServerWorld world = (IServerWorld)event.getWorld();
        MobEntity resourcefulBeeEntity = (MobEntity)RESOURCEFUL_BEES_LIST.get(world.func_201674_k().nextInt(RESOURCEFUL_BEES_LIST.size())).func_200721_a(entity.field_70170_p);
        if (resourcefulBeeEntity == null) {
            return;
        }
        resourcefulBeeEntity.func_82227_f(isChild);
        BlockPos.Mutable blockpos = new BlockPos.Mutable().func_189533_g((Vector3i)entity.func_233580_cy_());
        resourcefulBeeEntity.func_70012_b((double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.5f), (double)((float)blockpos.func_177952_p() + 0.5f), world.func_201674_k().nextFloat() * 360.0f, 0.0f);
        resourcefulBeeEntity.func_213386_a(world, world.func_175649_E(resourcefulBeeEntity.func_233580_cy_()), event.getSpawnReason(), null, null);
        world.func_217376_c((Entity)resourcefulBeeEntity);
    }

    public static BlockState RBGetSpiderHoneycomb(Random random) {
        if (SPIDER_DUNGEON_HONEYCOMBS.size() == 0) {
            return Blocks.field_226908_md_.func_176223_P();
        }
        return SPIDER_DUNGEON_HONEYCOMBS.get(random.nextInt(random.nextInt(SPIDER_DUNGEON_HONEYCOMBS.size()) + 1)).func_176223_P();
    }

    public static BlockState RBGetRandomHoneycomb(Random random, int lowerBoundBias) {
        if (ORE_BASED_HONEYCOMB_VARIANTS.size() == 0) {
            return Blocks.field_226908_md_.func_176223_P();
        }
        int index = ORE_BASED_HONEYCOMB_VARIANTS.size() - 1;
        for (int i = 0; i < lowerBoundBias && index != 0; ++i) {
            index = random.nextInt(index + 1);
        }
        return ORE_BASED_HONEYCOMB_VARIANTS.get(index).func_176223_P();
    }

    public static boolean isRBComb(Item itemToCheck) {
        return itemToCheck.equals(ModItems.SCRAPER.get());
    }
}

