/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DefaultDispenseItemBehaviorInvoker;
import com.telepathicgrunt.the_bumblezone.mixin.world.BiomeGenerationSettingsAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;

public class GeneralUtils {
    private static int ACTIVE_ENTITIES = 0;

    public static void updateEntityCount(ServerWorld world) {
        List entitiesList = world.func_217482_a(null, entity -> true);
        ACTIVE_ENTITIES = entitiesList.size();
    }

    public static int getEntityCountInBz() {
        return ACTIVE_ENTITIES;
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, Random random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static void makeBiomeMutable(Biome biome) {
        List<List<Supplier<ConfiguredFeature<?, ?>>>> tempFeature = ((BiomeGenerationSettingsAccessor)biome.func_242440_e()).thebumblezone_getFeatures();
        ArrayList mutableGenerationStages = new ArrayList();
        for (int currentStageIndex = 0; currentStageIndex < Math.max(GenerationStage.Decoration.values().length, tempFeature.size()); ++currentStageIndex) {
            if (currentStageIndex >= tempFeature.size()) {
                mutableGenerationStages.add(new ArrayList());
                continue;
            }
            mutableGenerationStages.add(new ArrayList(tempFeature.get(currentStageIndex)));
        }
        ((BiomeGenerationSettingsAccessor)biome.func_242440_e()).thebumblezone_setFeatures(mutableGenerationStages);
    }

    public static ItemStack dispenseStackProperly(IBlockSource source, ItemStack stack, IDispenseItemBehavior defaultDispenseBehavior) {
        if (defaultDispenseBehavior instanceof DefaultDispenseItemBehavior) {
            return ((DefaultDispenseItemBehaviorInvoker)defaultDispenseBehavior).thebumblezone_invokeExecute(source, stack);
        }
        return defaultDispenseBehavior.dispense(source, stack);
    }

    public static class BasicItemTrade
    implements VillagerTrades.ITrade {
        private final Item itemToTrade;
        private final Item itemToReceive;
        private final int amountToGive;
        private final int amountToReceive;
        protected final int maxUses;
        protected final int experience;
        protected final float multiplier;

        public BasicItemTrade(Item itemToTrade, int amountToGive, Item itemToReceive, int amountToReceive) {
            this(itemToTrade, amountToGive, itemToReceive, amountToReceive, 20, 2, 0.05f);
        }

        public BasicItemTrade(Item itemToTrade, int amountToGive, Item itemToReceive, int amountToReceive, int maxUses, int experience, float multiplier) {
            this.itemToTrade = itemToTrade;
            this.itemToReceive = itemToReceive;
            this.amountToGive = amountToGive;
            this.amountToReceive = amountToReceive;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public MerchantOffer func_221182_a(Entity entity, Random random) {
            ItemStack in = new ItemStack((IItemProvider)this.itemToTrade, this.amountToGive);
            ItemStack out = new ItemStack((IItemProvider)this.itemToReceive, this.amountToReceive);
            return new MerchantOffer(in, out, this.maxUses, this.experience, this.multiplier);
        }
    }
}

