/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.LayerAccessor;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeMergeLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeNonstandardLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomePillarLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeScalePillarLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;

public class BzBiomeProvider
extends BiomeProvider {
    public static final Codec<BzBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(vanillaLayeredBiomeSource -> vanillaLayeredBiomeSource.BIOME_REGISTRY)).apply((Applicative)instance, instance.stable(BzBiomeProvider::new)));
    public static ResourceLocation HIVE_WALL = new ResourceLocation("the_bumblezone", "hive_wall");
    public static ResourceLocation HIVE_PILLAR = new ResourceLocation("the_bumblezone", "hive_pillar");
    public static ResourceLocation SUGAR_WATER_FLOOR = new ResourceLocation("the_bumblezone", "sugar_water_floor");
    private final Layer BIOME_SAMPLER;
    private final Registry<Biome> BIOME_REGISTRY;
    public static Registry<Biome> LAYERS_BIOME_REGISTRY;
    public static List<Biome> NONSTANDARD_BIOME;

    public static void registerBiomeProvider() {
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("the_bumblezone", "biome_source"), CODEC);
    }

    public BzBiomeProvider(Registry<Biome> biomeRegistry) {
        this(0L, biomeRegistry);
    }

    public BzBiomeProvider(long seed, Registry<Biome> biomeRegistry) {
        super(biomeRegistry.func_239659_c_().stream().filter(entry -> ((RegistryKey)entry.getKey()).func_240901_a_().func_110624_b().equals("the_bumblezone")).map(Map.Entry::getValue).collect(Collectors.toList()));
        NONSTANDARD_BIOME = this.field_226837_c_.stream().filter(biome -> biomeRegistry.func_177774_c(biome) != HIVE_WALL && biomeRegistry.func_177774_c(biome) != HIVE_PILLAR && biomeRegistry.func_177774_c(biome) != SUGAR_WATER_FLOOR).collect(Collectors.toList());
        BzBiomeLayer.setSeed(seed);
        this.BIOME_REGISTRY = biomeRegistry;
        LAYERS_BIOME_REGISTRY = biomeRegistry;
        this.BIOME_SAMPLER = BzBiomeProvider.buildWorldProcedure(seed);
    }

    public static Layer buildWorldProcedure(long seed) {
        IAreaFactory layerFactory = BzBiomeProvider.build(salt -> new LazyAreaLayerContext(25, seed, salt));
        return new Layer(layerFactory);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> build(LongFunction<C> contextFactory) {
        IAreaFactory layer = BzBiomeLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(200L));
        layer = BzBiomePillarLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1008L), layer);
        layer = BzBiomeScalePillarLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1055L), layer);
        layer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2003L), layer);
        layer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2523L), layer);
        if (!NONSTANDARD_BIOME.isEmpty()) {
            IAreaFactory layerOverlay = BzBiomeNonstandardLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(204L));
            layerOverlay = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2423L), layerOverlay);
            layerOverlay = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2503L), layerOverlay);
            layerOverlay = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2603L), layerOverlay);
            layerOverlay = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2853L), layerOverlay);
            layerOverlay = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3583L), layerOverlay);
            layer = BzBiomeMergeLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(5583L), layerOverlay, layer);
        }
        return layer;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.sample(this.BIOME_REGISTRY, x, z);
    }

    public Biome sample(Registry<Biome> dynamicBiomeRegistry, int x, int z) {
        int resultBiomeID = ((LayerAccessor)this.BIOME_SAMPLER).thebumblezone_getSampler().func_202678_a(x, z);
        Biome biome = (Biome)dynamicBiomeRegistry.func_148745_a(resultBiomeID);
        if (biome == null) {
            if (SharedConstants.field_206244_b) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Unknown biome id: " + resultBiomeID));
            }
            RegistryKey backupBiomeKey = BiomeRegistry.func_244203_a((int)0);
            Bumblezone.LOGGER.warn("Unknown biome id: ${}. Will spawn ${} instead.", (Object)resultBiomeID, (Object)backupBiomeKey.func_240901_a_());
            return (Biome)dynamicBiomeRegistry.func_230516_a_(backupBiomeKey);
        }
        return biome;
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new BzBiomeProvider(seed, this.BIOME_REGISTRY);
    }

    static {
        NONSTANDARD_BIOME = new ArrayList<Biome>();
    }
}

