/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.utils.BzPlacingUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraftforge.common.ForgeHooks;

public class BzChunkGenerator
extends ChunkGenerator {
    public static final Codec<BzChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(surfaceChunkGenerator -> surfaceChunkGenerator.field_222542_c), (App)DimensionStructuresSettings.field_236190_a_.fieldOf("structures").forGetter(ChunkGenerator::func_235957_b_)).apply((Applicative)instance, instance.stable(BzChunkGenerator::new)));
    private static final float[] field_16649 = (float[])Util.func_200696_a((Object)new float[13824], array -> {
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                for (int k = 0; k < 24; ++k) {
                    array[i * 24 * 24 + j * 24 + k] = (float)BzChunkGenerator.method_16571(j - 12, k - 12, i - 12);
                }
            }
        }
    });
    private static final int LERP_RANGE = 3;
    private static final float[] HEIGHT_LERP = (float[])Util.func_200696_a((Object)new float[49], fs -> {
        for (int i = -3; i <= 3; ++i) {
            for (int j = -3; j <= 3; ++j) {
                float f;
                fs[i + 3 + (j + 3) * 7] = f = 1.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private static final MobSpawnInfo.Spawners INITIAL_HONEY_SLIME_ENTRY = new MobSpawnInfo.Spawners((EntityType)BzEntities.HONEY_SLIME.get(), 1, 1, 3);
    private static final MobSpawnInfo.Spawners INITIAL_BEE_ENTRY = new MobSpawnInfo.Spawners(EntityType.field_226289_e_, 1, 2, 4);
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    private final int verticalNoiseResolution;
    private final int horizontalNoiseResolution;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    protected final SharedSeedRandom random = new SharedSeedRandom(0L);
    private final OctavesNoiseGenerator lowerInterpolatedNoise;
    private final OctavesNoiseGenerator upperInterpolatedNoise;
    private final OctavesNoiseGenerator interpolationNoise;
    private final INoiseGenerator surfaceDepthNoise;
    private final OctavesNoiseGenerator field_24776;
    private final DimensionStructuresSettings dimensionStructuresSettings;
    private final int height;

    public static void registerChunkgenerator() {
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation("the_bumblezone", "chunk_generator"), CODEC);
    }

    public BzChunkGenerator(BiomeProvider biomeSource, DimensionStructuresSettings dimensionStructuresSettings) {
        this(biomeSource, biomeSource, dimensionStructuresSettings);
    }

    private BzChunkGenerator(BiomeProvider biomeSource, BiomeProvider biomeSource2, DimensionStructuresSettings dimensionStructuresSettings) {
        super(biomeSource, biomeSource2, dimensionStructuresSettings, 0L);
        this.dimensionStructuresSettings = dimensionStructuresSettings;
        this.height = 256;
        this.verticalNoiseResolution = 8;
        this.horizontalNoiseResolution = 4;
        this.defaultBlock = Blocks.field_226908_md_.func_176223_P();
        this.defaultFluid = ((FlowingFluidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).func_176223_P();
        this.noiseSizeX = 16 / this.horizontalNoiseResolution;
        this.noiseSizeY = this.height / this.verticalNoiseResolution;
        this.noiseSizeZ = 16 / this.horizontalNoiseResolution;
        this.lowerInterpolatedNoise = new OctavesNoiseGenerator(this.random, IntStream.rangeClosed(-15, 0));
        this.upperInterpolatedNoise = new OctavesNoiseGenerator(this.random, IntStream.rangeClosed(-15, 0));
        this.interpolationNoise = new OctavesNoiseGenerator(this.random, IntStream.rangeClosed(-7, 0));
        this.surfaceDepthNoise = new PerlinNoiseGenerator(this.random, IntStream.rangeClosed(-3, 0));
        this.random.func_202423_a(2620);
        this.field_24776 = new OctavesNoiseGenerator(this.random, IntStream.rangeClosed(-15, 0));
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    public ChunkGenerator func_230349_a_(long seed) {
        return new BzChunkGenerator(this.field_222542_c.func_230320_a_(seed), this.dimensionStructuresSettings);
    }

    private double sampleNoise(int x, int y, int z, double horizontalScaleX, double verticalScale, double horizontalScaleZ, double horizontalStretch, double verticalStretch) {
        double d = 0.0;
        double e = 0.0;
        double f = 0.0;
        double g = 1.0;
        for (int i = 0; i < 16; ++i) {
            ImprovedNoiseGenerator perlinNoiseSampler3;
            ImprovedNoiseGenerator perlinNoiseSampler2;
            double h = OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalScaleX * g));
            double j = OctavesNoiseGenerator.func_215461_a((double)((double)y * verticalScale * g));
            double k = OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalScaleZ * g));
            double l = verticalScale * g;
            ImprovedNoiseGenerator perlinNoiseSampler = this.lowerInterpolatedNoise.func_215463_a(i);
            if (perlinNoiseSampler != null) {
                d += perlinNoiseSampler.func_215456_a(h, j, k, l, (double)y * l) / g;
            }
            if ((perlinNoiseSampler2 = this.upperInterpolatedNoise.func_215463_a(i)) != null) {
                e += perlinNoiseSampler2.func_215456_a(h, j, k, l, (double)y * l) / g;
            }
            if (i < 8 && (perlinNoiseSampler3 = this.interpolationNoise.func_215463_a(i)) != null) {
                f += perlinNoiseSampler3.func_215456_a(OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalStretch * g)), OctavesNoiseGenerator.func_215461_a((double)((double)y * verticalStretch * g)), OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalStretch * g)), verticalStretch * g, (double)y * verticalStretch * g) / g;
            }
            g /= 2.0;
        }
        return MathHelper.func_151238_b((double)(d / 512.0), (double)(e / 512.0), (double)((f / 10.0 + 1.0) / 2.0));
    }

    private double[] sampleNoiseColumn(int x, int z) {
        double[] ds = new double[this.noiseSizeY + 1];
        this.sampleNoiseColumn(ds, x, z);
        return ds;
    }

    private void sampleNoiseColumn(double[] buffer, int x, int z) {
        float g = 0.0f;
        float h = 0.0f;
        float i = 0.0f;
        int k = this.func_230356_f_();
        float l = this.field_222542_c.func_225526_b_(x, k, z).func_185355_j();
        for (int m = -3; m <= 3; ++m) {
            for (int n = -3; n <= 3; ++n) {
                Biome biome = this.field_222542_c.func_225526_b_(x + m, k, z + n);
                float o = biome.func_185355_j();
                float p = biome.func_185360_m();
                float u = o > l ? 0.5f : 1.0f;
                float v = u * HEIGHT_LERP[m + 3 + (n + 3) * 7] / 3.0f;
                g += p * v;
                h += o * v;
                i += v;
            }
        }
        float w = h / i;
        float yy = g / i;
        double topSlideTarget = w * 0.5f - 0.125f;
        double topSlideSize = yy * 0.9f + 0.1f;
        double ac = topSlideTarget * 0.265625;
        double ad = 96.0 / topSlideSize;
        double xScale = 2600.0;
        double zScale = 250.0;
        double yScale = 16.0;
        double xzStretch = 8.0;
        double yStretch = 2.0;
        topSlideTarget = -10.0;
        topSlideSize = 3.0;
        double topSlideOffset = 0.0;
        double randomDensity = this.method_28553(x, z);
        double densityFactor = 1.0;
        double densityOffset = -0.46875;
        for (int y = 0; y <= this.noiseSizeY; ++y) {
            double as = this.sampleNoise(x, y * 2, z, xScale, yScale, zScale, xzStretch, yStretch);
            double at = 1.0 - (double)y * 2.0 / (double)this.noiseSizeY + randomDensity;
            double au = at * densityFactor + densityOffset;
            double av = (au + ac) * ad;
            as = av > 0.0 ? (as += av * 4.0) : (as += av);
            double ax = ((double)(this.noiseSizeY - y) - topSlideOffset) / topSlideSize;
            buffer[y] = as = MathHelper.func_151238_b((double)topSlideTarget, (double)as, (double)ax);
        }
    }

    private double method_28553(int i, int j) {
        double d = this.field_24776.func_215462_a((double)(i * 200), 10.0, (double)(j * 200), 1.0, 0.0, true);
        double f = d < 0.0 ? -d * 0.3 : d;
        double g = f * 24.575625 - 2.0;
        return g < 0.0 ? g * 0.009486607142857142 : Math.min(g, 1.0) * 0.006640625;
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        return this.sampleHeightmap(x, z, null, heightmapType.func_222684_d());
    }

    public IBlockReader func_230348_a_(int x, int z) {
        BlockState[] blockStates = new BlockState[this.noiseSizeY * this.verticalNoiseResolution];
        this.sampleHeightmap(x, z, blockStates, null);
        return new Blockreader(blockStates);
    }

    private int sampleHeightmap(int x, int z, BlockState[] states, Predicate<BlockState> predicate) {
        int i = Math.floorDiv(x, this.horizontalNoiseResolution);
        int j = Math.floorDiv(z, this.horizontalNoiseResolution);
        int k = Math.floorMod(x, this.horizontalNoiseResolution);
        int l = Math.floorMod(z, this.horizontalNoiseResolution);
        double d = (double)k / (double)this.horizontalNoiseResolution;
        double e = (double)l / (double)this.horizontalNoiseResolution;
        double[][] ds = new double[][]{this.sampleNoiseColumn(i, j), this.sampleNoiseColumn(i, j + 1), this.sampleNoiseColumn(i + 1, j), this.sampleNoiseColumn(i + 1, j + 1)};
        for (int m = this.noiseSizeY - 1; m >= 0; --m) {
            double f = ds[0][m];
            double g = ds[1][m];
            double h = ds[2][m];
            double n = ds[3][m];
            double o = ds[0][m + 1];
            double p = ds[1][m + 1];
            double q = ds[2][m + 1];
            double r = ds[3][m + 1];
            for (int s = this.verticalNoiseResolution - 1; s >= 0; --s) {
                double t = (double)s / (double)this.verticalNoiseResolution;
                double u = MathHelper.func_219807_a((double)t, (double)d, (double)e, (double)f, (double)o, (double)h, (double)q, (double)g, (double)p, (double)n, (double)r);
                int v = m * this.verticalNoiseResolution + s;
                BlockState blockState = this.getBlockState(u, v);
                if (states != null) {
                    states[v] = blockState;
                }
                if (predicate == null || !predicate.test(blockState)) continue;
                return v + 1;
            }
        }
        return 0;
    }

    protected BlockState getBlockState(double density, int y) {
        BlockState blockState3 = density > 0.0 ? this.defaultBlock : (y < this.func_230356_f_() ? this.defaultFluid : CAVE_AIR);
        return blockState3;
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int i = chunkPos.field_77276_a;
        int j = chunkPos.field_77275_b;
        SharedSeedRandom chunkRandom = new SharedSeedRandom();
        chunkRandom.func_202422_a(i, j);
        ChunkPos chunkPos2 = chunk.func_76632_l();
        int k = chunkPos2.func_180334_c();
        int l = chunkPos2.func_180333_d();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int m = 0; m < 16; ++m) {
            for (int n = 0; n < 16; ++n) {
                int o = k + m;
                int p = l + n;
                int q = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, m, n) + 1;
                double e = this.surfaceDepthNoise.func_215460_a((double)o * 0.0625, (double)p * 0.0625, 0.0625, (double)m * 0.0625) * 15.0;
                region.func_226691_t_((BlockPos)mutable.func_181079_c(k + m, q, l + n)).func_206854_a((Random)chunkRandom, chunk, o, p, q, e, this.defaultBlock, this.defaultFluid, this.func_230356_f_(), region.func_72905_C());
            }
        }
        this.makeCeilingAndFloor(chunk, (Random)chunkRandom);
    }

    public void func_230352_b_(IWorld world, StructureManager accessor, IChunk chunk) {
        ObjectArrayList objectList = new ObjectArrayList(10);
        ObjectArrayList objectList2 = new ObjectArrayList(32);
        ChunkPos chunkPos = chunk.func_76632_l();
        int i = chunkPos.field_77276_a;
        int j = chunkPos.field_77275_b;
        int k = i << 4;
        int l = j << 4;
        for (Structure feature : Structure.field_236384_t_) {
            accessor.func_235011_a_(SectionPos.func_218156_a((ChunkPos)chunkPos, (int)0), feature).forEach(arg_0 -> BzChunkGenerator.lambda$fillFromNoise$4(chunkPos, (ObjectList)objectList, k, l, (ObjectList)objectList2, arg_0));
        }
        double[][][] ds = new double[2][this.noiseSizeZ + 1][this.noiseSizeY + 1];
        for (int m = 0; m < this.noiseSizeZ + 1; ++m) {
            ds[0][m] = new double[this.noiseSizeY + 1];
            this.sampleNoiseColumn(ds[0][m], i * this.noiseSizeX, j * this.noiseSizeZ + m);
            ds[1][m] = new double[this.noiseSizeY + 1];
        }
        ChunkPrimer protoChunk = (ChunkPrimer)chunk;
        Heightmap heightmap = protoChunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap2 = protoChunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        ObjectListIterator objectListIterator = objectList.iterator();
        ObjectListIterator objectListIterator2 = objectList2.iterator();
        for (int n = 0; n < this.noiseSizeX; ++n) {
            int p;
            for (p = 0; p < this.noiseSizeZ + 1; ++p) {
                this.sampleNoiseColumn(ds[1][p], i * this.noiseSizeX + n + 1, j * this.noiseSizeZ + p);
            }
            for (p = 0; p < this.noiseSizeZ; ++p) {
                ChunkSection chunkSection = protoChunk.func_217332_a(15);
                chunkSection.func_222635_a();
                for (int ySection = this.noiseSizeY - 1; ySection >= 0; --ySection) {
                    double t;
                    double s;
                    double r;
                    double h;
                    double g;
                    double f;
                    double e;
                    double d;
                    if (ySection > 15) {
                        int tempYSection = ySection;
                        ySection = 31 - ySection;
                        d = ds[0][p][ySection + 1];
                        e = ds[0][p + 1][ySection + 1];
                        f = ds[1][p][ySection + 1];
                        g = ds[1][p + 1][ySection + 1];
                        h = ds[0][p][ySection];
                        r = ds[0][p + 1][ySection];
                        s = ds[1][p][ySection];
                        t = ds[1][p + 1][ySection];
                        ySection = tempYSection;
                    } else {
                        d = ds[0][p][ySection];
                        e = ds[0][p + 1][ySection];
                        f = ds[1][p][ySection];
                        g = ds[1][p + 1][ySection];
                        h = ds[0][p][ySection + 1];
                        r = ds[0][p + 1][ySection + 1];
                        s = ds[1][p][ySection + 1];
                        t = ds[1][p + 1][ySection + 1];
                    }
                    for (int yInChunk = this.verticalNoiseResolution - 1; yInChunk >= 0; --yInChunk) {
                        int currentY = ySection * this.verticalNoiseResolution + yInChunk;
                        int yPosInChunkSection = currentY & 0xF;
                        int yChunkSection = currentY >> 4;
                        if (chunkSection.func_222632_g() >> 4 != yChunkSection) {
                            chunkSection.func_222637_b();
                            chunkSection = protoChunk.func_217332_a(yChunkSection);
                            chunkSection.func_222635_a();
                        }
                        double y = (double)yInChunk / (double)this.verticalNoiseResolution;
                        double z = MathHelper.func_219803_d((double)y, (double)d, (double)h);
                        double aa = MathHelper.func_219803_d((double)y, (double)f, (double)s);
                        double ab = MathHelper.func_219803_d((double)y, (double)e, (double)r);
                        double ac = MathHelper.func_219803_d((double)y, (double)g, (double)t);
                        for (int ad = 0; ad < this.horizontalNoiseResolution; ++ad) {
                            int ae = k + n * this.horizontalNoiseResolution + ad;
                            int af = ae & 0xF;
                            double ag = (double)ad / (double)this.horizontalNoiseResolution;
                            double ah = MathHelper.func_219803_d((double)ag, (double)z, (double)aa);
                            double ai = MathHelper.func_219803_d((double)ag, (double)ab, (double)ac);
                            for (int aj = 0; aj < this.horizontalNoiseResolution; ++aj) {
                                int au;
                                int at;
                                int ak = l + p * this.horizontalNoiseResolution + aj;
                                int al = ak & 0xF;
                                double am = (double)aj / (double)this.horizontalNoiseResolution;
                                double an = MathHelper.func_219803_d((double)am, (double)ah, (double)ai);
                                double ao = MathHelper.func_151237_a((double)(an / 200.0), (double)-1.0, (double)1.0);
                                ao = ao / 2.0 - ao * ao * ao / 24.0;
                                while (objectListIterator.hasNext()) {
                                    StructurePiece structurePiece = (StructurePiece)objectListIterator.next();
                                    MutableBoundingBox blockBox = structurePiece.func_74874_b();
                                    at = Math.max(0, Math.max(blockBox.field_78897_a - ae, ae - blockBox.field_78893_d));
                                    au = currentY - (blockBox.field_78895_b + (structurePiece instanceof AbstractVillagePiece ? ((AbstractVillagePiece)structurePiece).func_214830_d() : 0));
                                    int ar = Math.max(0, Math.max(blockBox.field_78896_c - ak, ak - blockBox.field_78892_f));
                                    ao += BzChunkGenerator.method_16572(at, au, ar) * 0.8;
                                }
                                objectListIterator.back(objectList.size());
                                while (objectListIterator2.hasNext()) {
                                    JigsawJunction jigsawJunction = (JigsawJunction)objectListIterator2.next();
                                    int as = ae - jigsawJunction.func_214895_a();
                                    at = currentY - jigsawJunction.func_214896_b();
                                    au = ak - jigsawJunction.func_214893_c();
                                    ao += BzChunkGenerator.method_16572(as, at, au) * 0.4;
                                }
                                objectListIterator2.back(objectList2.size());
                                BlockState blockState = this.getBlockState(ao, currentY);
                                if (blockState == CAVE_AIR) continue;
                                if (blockState.func_185906_d() != 0) {
                                    mutable.func_181079_c(ae, currentY, ak);
                                    protoChunk.func_201637_h((BlockPos)mutable);
                                }
                                chunkSection.func_177484_a(af, yPosInChunkSection, al, blockState, false);
                                heightmap.func_202270_a(af, currentY, al, blockState);
                                heightmap2.func_202270_a(af, currentY, al, blockState);
                            }
                        }
                    }
                }
                chunkSection.func_222637_b();
            }
            double[][] es = ds[0];
            ds[0] = ds[1];
            ds[1] = es;
        }
    }

    private static double method_16572(int i, int j, int k) {
        int l = i + 12;
        int m = j + 12;
        int n = k + 12;
        if (l >= 0 && l < 24) {
            if (m >= 0 && m < 24) {
                return n >= 0 && n < 24 ? (double)field_16649[n * 24 * 24 + l * 24 + m] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double method_16571(int i, int j, int k) {
        double d = i * i + k * k;
        double e = (double)j + 0.5;
        double f = e * e;
        double g = Math.pow(Math.E, -(f / 16.0 + d / 16.0));
        double h = -e * MathHelper.func_181161_i((double)(f / 2.0 + d / 2.0)) / 2.0;
        return h * g;
    }

    public int func_230355_e_() {
        return this.height;
    }

    public List<MobSpawnInfo.Spawners> func_230353_a_(Biome biome, StructureManager accessor, EntityClassification group, BlockPos pos) {
        return super.func_230353_a_(biome, accessor, group, pos);
    }

    public void func_230354_a_(WorldGenRegion region) {
        int xChunk = region.func_201679_a();
        int zChunk = region.func_201680_b();
        int xCord = xChunk << 4;
        int zCord = zChunk << 4;
        Biome biome = region.func_226691_t_(new ChunkPos(xChunk, zChunk).func_206849_h());
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), xCord, zCord);
        while (sharedseedrandom.nextFloat() < biome.func_242433_b().func_242557_a() * 0.75f) {
            MobEntity mobentity;
            MobSpawnInfo.Spawners biome$spawnlistentry = sharedseedrandom.nextFloat() < 0.25f ? INITIAL_HONEY_SLIME_ENTRY : INITIAL_BEE_ENTRY;
            int startingX = xCord + sharedseedrandom.nextInt(16);
            int startingZ = zCord + sharedseedrandom.nextInt(16);
            BlockPos.Mutable blockpos = new BlockPos.Mutable(startingX, 0, startingZ);
            int height = BzPlacingUtils.topOfSurfaceBelowHeight((IWorld)region, sharedseedrandom.nextInt(255), -1, (BlockPos)blockpos) + 1;
            if (!biome$spawnlistentry.field_242588_c.func_200720_b() || height <= 0 || height >= 255) continue;
            float width = biome$spawnlistentry.field_242588_c.func_220333_h();
            double xLength = MathHelper.func_151237_a((double)startingX, (double)((double)xCord + (double)width), (double)((double)xCord + 16.0 - (double)width));
            double zLength = MathHelper.func_151237_a((double)startingZ, (double)((double)zCord + (double)width), (double)((double)zCord + 16.0 - (double)width));
            Entity entity = biome$spawnlistentry.field_242588_c.func_200721_a((World)region.func_201672_e());
            if (entity == null) continue;
            entity.func_70012_b(xLength, (double)height, zLength, sharedseedrandom.nextFloat() * 360.0f, 0.0f);
            if (!(entity instanceof MobEntity) || ForgeHooks.canEntitySpawn((MobEntity)(mobentity = (MobEntity)entity), (IWorld)region, (double)((double)blockpos.func_177958_n() + 0.5), (double)((double)blockpos.func_177956_o() + 0.5), (double)((double)blockpos.func_177952_p() + 0.5), null, (SpawnReason)SpawnReason.CHUNK_GENERATION) == -1 || !mobentity.func_213380_a((IWorld)region, SpawnReason.CHUNK_GENERATION) || !mobentity.func_205019_a((IWorldReader)region)) continue;
            mobentity.func_213386_a((IServerWorld)region, region.func_175649_E(new BlockPos((Vector3i)mobentity.func_233580_cy_())), SpawnReason.CHUNK_GENERATION, null, null);
            region.func_217376_c((Entity)mobentity);
        }
    }

    protected void makeCeilingAndFloor(IChunk chunk, Random random) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        int xStart = chunk.func_76632_l().func_180334_c();
        int zStart = chunk.func_76632_l().func_180333_d();
        int roofHeight = 250;
        int floorHeight = 2;
        for (BlockPos blockpos : BlockPos.func_191531_b((int)xStart, (int)0, (int)zStart, (int)(xStart + 15), (int)0, (int)(zStart + 15))) {
            for (int ceilingY = 255; ceilingY >= roofHeight - random.nextInt(2); --ceilingY) {
                chunk.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(blockpos.func_177958_n(), ceilingY, blockpos.func_177952_p()), ((Block)BzBlocks.BEESWAX_PLANKS.get()).func_176223_P(), false);
            }
            for (int floorY = 0; floorY <= floorHeight + random.nextInt(2); ++floorY) {
                chunk.func_177436_a((BlockPos)blockpos$Mutable.func_181079_c(blockpos.func_177958_n(), floorY, blockpos.func_177952_p()), ((Block)BzBlocks.BEESWAX_PLANKS.get()).func_176223_P(), false);
            }
        }
    }

    public int func_230356_f_() {
        return 40;
    }

    private static /* synthetic */ void lambda$fillFromNoise$4(ChunkPos chunkPos, ObjectList objectList, int k, int l, ObjectList objectList2, StructureStart start) {
        Iterator structurePiecesIterator = start.func_186161_c().iterator();
        block0: while (structurePiecesIterator.hasNext()) {
            StructurePiece structurePiece = (StructurePiece)structurePiecesIterator.next();
            if (!structurePiece.func_214810_a(chunkPos, 12)) continue;
            if (structurePiece instanceof AbstractVillagePiece) {
                AbstractVillagePiece poolStructurePiece = (AbstractVillagePiece)structurePiece;
                JigsawPattern.PlacementBehaviour projection = poolStructurePiece.func_214826_b().func_214854_c();
                if (projection == JigsawPattern.PlacementBehaviour.RIGID) {
                    objectList.add((Object)poolStructurePiece);
                }
                Iterator iterator = poolStructurePiece.func_214829_e().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    JigsawJunction jigsawJunction = (JigsawJunction)iterator.next();
                    int kx = jigsawJunction.func_214895_a();
                    int lx = jigsawJunction.func_214893_c();
                    if (kx <= k - 12 || lx <= l - 12 || kx >= k + 15 + 12 || lx >= l + 15 + 12) continue;
                    objectList2.add((Object)jigsawJunction);
                }
            }
            objectList.add((Object)structurePiece);
        }
        return;
    }
}

