/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.tags.BZBlockTags;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CaveSugarWaterfall
extends Feature<NoFeatureConfig> {
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();

    public CaveSugarWaterfall(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random random, BlockPos position, NoFeatureConfig config) {
        int neededNumberOfSides;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        BlockState blockstate = world.func_180495_p(blockpos$Mutable.func_177984_a());
        if (!blockstate.func_200132_m() || blockstate.func_235714_a_(BZBlockTags.HONEYCOMBS_THAT_FEATURES_CAN_CARVE)) {
            return false;
        }
        int numberOfSolidSides = 0;
        blockstate = world.func_180495_p(blockpos$Mutable.func_177977_b());
        if (blockstate.func_200132_m() && blockstate.func_235714_a_(BZBlockTags.HONEYCOMBS_THAT_FEATURES_CAN_CARVE)) {
            neededNumberOfSides = 3;
        } else if (blockstate.func_177230_c() == CAVE_AIR.func_177230_c()) {
            neededNumberOfSides = 4;
        } else {
            return false;
        }
        for (Direction face : Direction.Plane.HORIZONTAL) {
            blockstate = world.func_180495_p(blockpos$Mutable.func_177972_a(face));
            if (blockstate.func_200132_m() && blockstate.func_235714_a_(BZBlockTags.HONEYCOMBS_THAT_FEATURES_CAN_CARVE)) {
                ++numberOfSolidSides;
                continue;
            }
            if (blockstate.func_177230_c() == CAVE_AIR.func_177230_c()) continue;
            return false;
        }
        if (numberOfSolidSides == neededNumberOfSides) {
            world.func_180501_a((BlockPos)blockpos$Mutable, ((FlowingFluidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).func_176223_P(), 2);
            world.func_205219_F_().func_205360_a((BlockPos)blockpos$Mutable, (Object)BzFluids.SUGAR_WATER_FLUID.get(), 0);
        }
        return true;
    }
}

