/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ResourcefulBeesRedirection;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class HoneycombHole
extends Feature<NoFeatureConfig> {
    private static final int[][] bodyLayout = new int[][]{{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 3, 3, 3, 3, 1, 0, 0, 0}, {0, 0, 1, 3, 3, 3, 3, 3, 3, 1, 0, 0}, {0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 1, 0}, {1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1}, {1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1}, {0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 1, 0}, {0, 0, 1, 3, 3, 3, 3, 3, 3, 1, 0, 0}, {0, 0, 0, 1, 3, 3, 3, 3, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}};
    private static final int[][] largeHoneyLayout = new int[][]{{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 2, 2, 1, 1, 0, 0, 0}, {0, 0, 1, 1, 2, 2, 2, 2, 1, 1, 0, 0}, {0, 1, 1, 2, 2, 3, 3, 2, 2, 1, 1, 0}, {1, 1, 2, 2, 3, 3, 3, 3, 2, 2, 1, 1}, {1, 1, 2, 2, 3, 3, 3, 3, 2, 2, 1, 1}, {0, 1, 1, 2, 2, 3, 3, 2, 2, 1, 1, 0}, {0, 0, 1, 1, 2, 2, 2, 2, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 2, 2, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}};
    private static final int[][] smallHoneyLayout = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 2, 2, 1, 1, 0, 0, 0}, {0, 0, 1, 1, 2, 5, 5, 2, 1, 1, 0, 0}, {0, 0, 1, 1, 2, 5, 5, 2, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 2, 2, 1, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private static final int[][] endCapLayout = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

    public HoneycombHole(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random random, BlockPos position, NoFeatureConfig config) {
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos, endCapLayout, random, true);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos.func_189536_c(Direction.EAST), smallHoneyLayout, random, true);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos.func_189536_c(Direction.EAST), largeHoneyLayout, random, true);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos.func_189536_c(Direction.EAST), bodyLayout, random, true);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos.func_189536_c(Direction.EAST), bodyLayout, random, true);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos.func_189536_c(Direction.EAST), bodyLayout, random, false);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos.func_189536_c(Direction.EAST), bodyLayout, random, false);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos.func_189536_c(Direction.EAST), bodyLayout, random, false);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos.func_189536_c(Direction.EAST), largeHoneyLayout, random, false);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos.func_189536_c(Direction.EAST), smallHoneyLayout, random, false);
        this.generateSlice((IServerWorld)world, generator, mutableBlockPos.func_189536_c(Direction.EAST), endCapLayout, random, false);
        return true;
    }

    private void generateSlice(IServerWorld world, ChunkGenerator generator, BlockPos.Mutable centerPos, int[][] slice, Random random, boolean westEnd) {
        BlockPos.Mutable currentPosition = new BlockPos.Mutable().func_189533_g((Vector3i)centerPos.func_177982_a(-5, slice.length / 2, -slice[0].length / 2));
        for (int[] ints : slice) {
            for (int z = 0; z < slice[0].length; ++z) {
                BlockState state = world.func_180495_p((BlockPos)currentPosition);
                if (!state.func_204520_s().func_206888_e() && currentPosition.func_177956_o() >= generator.func_230356_f_()) {
                    world.func_180501_a((BlockPos)currentPosition, Blocks.field_201941_jj.func_176223_P(), 2);
                } else if (state.func_185904_a() != Material.field_151579_a) {
                    int sliceBlock = ints[z];
                    if (sliceBlock == 1) {
                        if (world.func_180495_p(currentPosition.func_177976_e()).func_200132_m() && world.func_180495_p(currentPosition.func_177974_f()).func_200132_m()) {
                            if (random.nextInt(3) == 0) {
                                world.func_180501_a((BlockPos)currentPosition, Blocks.field_226908_md_.func_176223_P(), 2);
                            } else {
                                world.func_180501_a((BlockPos)currentPosition, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P(), 2);
                            }
                        }
                    } else if (sliceBlock == 2) {
                        if (random.nextInt(3) == 0) {
                            world.func_180501_a((BlockPos)currentPosition, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P(), 2);
                        } else if (ModChecker.resourcefulBeesPresent && random.nextFloat() < 0.01f) {
                            world.func_180501_a((BlockPos)currentPosition, ResourcefulBeesRedirection.getRBHoneyBlock(random), 2);
                        } else {
                            world.func_180501_a((BlockPos)currentPosition, Blocks.field_226907_mc_.func_176223_P(), 2);
                        }
                    } else if (sliceBlock == 3) {
                        if (currentPosition.func_177956_o() >= generator.func_230356_f_()) {
                            world.func_180501_a((BlockPos)currentPosition, Blocks.field_201941_jj.func_176223_P(), 2);
                        } else {
                            world.func_180501_a((BlockPos)currentPosition, ((FlowingFluidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).func_176223_P(), 2);
                        }
                    } else if (sliceBlock == 5) {
                        int chance = random.nextInt(10);
                        if (chance <= 3) {
                            Direction facing = westEnd ? Direction.WEST : Direction.EAST;
                            if (random.nextFloat() < 0.8f) {
                                world.func_180501_a((BlockPos)currentPosition, (BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).func_176223_P().func_206870_a((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).func_206870_a((Property)HoneycombBrood.field_176387_N, (Comparable)facing), 2);
                            } else {
                                world.func_180501_a((BlockPos)currentPosition, (BlockState)((Block)BzBlocks.EMPTY_HONEYCOMB_BROOD.get()).func_176223_P().func_206870_a((Property)HoneycombBrood.field_176387_N, (Comparable)facing), 2);
                            }
                        } else if (chance <= 6) {
                            world.func_180501_a((BlockPos)currentPosition, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P(), 2);
                        } else if (ModChecker.resourcefulBeesPresent && random.nextFloat() < 0.01f) {
                            world.func_180501_a((BlockPos)currentPosition, ResourcefulBeesRedirection.getRBHoneyBlock(random), 2);
                        } else {
                            world.func_180501_a((BlockPos)currentPosition, Blocks.field_226907_mc_.func_176223_P(), 2);
                        }
                    }
                }
                currentPosition.func_189536_c(Direction.SOUTH);
            }
            currentPosition.func_196234_d(0, -1, -slice[0].length);
        }
    }
}

