/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.TemplateAccessor;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.world.features.configs.NbtFeatureConfig;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class NbtFeature
extends Feature<NbtFeatureConfig> {
    public NbtFeature(Codec<NbtFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NbtFeatureConfig config) {
        ResourceLocation nbtRL = (ResourceLocation)GeneralUtils.getRandomEntry(config.nbtResourcelocationsAndWeights, random);
        TemplateManager structureManager = world.func_201672_e().func_184163_y();
        Template template = structureManager.func_200219_b(nbtRL);
        if (template == null) {
            Bumblezone.LOGGER.error("Identifier to the specified nbt file was not found! : {}", (Object)nbtRL);
            return false;
        }
        Rotation rotation = Rotation.func_222466_a((Random)random);
        BlockPos halfLengths = new BlockPos(template.func_186259_a().func_177958_n() / 2, template.func_186259_a().func_177956_o() / 2, template.func_186259_a().func_177952_p() / 2);
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        position = position.func_177981_b(config.structureYOffset);
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_207665_a(halfLengths).func_186222_a(false);
        Optional processor = world.func_201672_e().func_73046_m().func_244267_aX().func_243612_b(Registry.field_243554_aw).func_241873_b(config.processor);
        processor.orElse(ProcessorLists.field_244101_a).func_242919_a().forEach(arg_0 -> ((PlacementSettings)placementsettings).func_215222_a(arg_0));
        template.func_237152_b_((IServerWorld)world, (BlockPos)mutable.func_189533_g((Vector3i)position).func_196234_d(-halfLengths.func_177958_n(), 0, -halfLengths.func_177952_p()), placementsettings, random);
        placementsettings.func_215219_b();
        Optional postProcessor = world.func_201672_e().func_73046_m().func_244267_aX().func_243612_b(Registry.field_243554_aw).func_241873_b(config.postProcessor);
        postProcessor.orElse(ProcessorLists.field_244101_a).func_242919_a().forEach(arg_0 -> ((PlacementSettings)placementsettings).func_215222_a(arg_0));
        List list = placementsettings.func_237132_a_(((TemplateAccessor)template).thebumblezone_getBlocks(), (BlockPos)mutable).func_237157_a_();
        Template.func_237145_a_((IWorld)world, (BlockPos)mutable, (BlockPos)mutable, (PlacementSettings)placementsettings, (List)list);
        return true;
    }
}

