/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyCrystal;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.modcompat.BuzzierBeesRedirection;
import com.telepathicgrunt.the_bumblezone.modcompat.CharmRedirection;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ProductiveBeesRedirection;
import com.telepathicgrunt.the_bumblezone.modcompat.ResourcefulBeesRedirection;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class BeeDungeonProcessor
extends StructureProcessor {
    public static final Codec<BeeDungeonProcessor> CODEC = Codec.unit(BeeDungeonProcessor::new);

    private BeeDungeonProcessor() {
    }

    public Template.BlockInfo func_230386_a_(IWorldReader worldView, BlockPos pos, BlockPos blockPos, Template.BlockInfo structureBlockInfoLocal, Template.BlockInfo structureBlockInfoWorld, PlacementSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.field_186243_b;
        BlockPos worldPos = structureBlockInfoWorld.field_186242_a;
        SharedSeedRandom random = new SharedSeedRandom();
        random.setSeed(worldPos.func_218275_a() * (long)worldPos.func_177956_o());
        if (blockState.func_203425_a(Blocks.field_185779_df)) {
            String metadata = structureBlockInfoWorld.field_186244_c.func_74779_i("metadata");
            BlockState belowBlock = worldView.func_217349_x(worldPos).func_180495_p(worldPos);
            if (belowBlock.func_196958_f()) {
                blockState = Blocks.field_201941_jj.func_176223_P();
            } else {
                switch (metadata) {
                    case "center": {
                        if (ModChecker.buzzierBeesPresent && random.nextFloat() < 0.8f && Bumblezone.BzModCompatibilityConfig.allowScentedCandlesBeeDungeon.get().booleanValue()) {
                            blockState = BuzzierBeesRedirection.BBGetRandomTier3Candle((Random)random, Bumblezone.BzModCompatibilityConfig.powerfulCandlesRarityBeeDungeon.get() + 1, random.nextInt(random.nextInt(random.nextInt(3) + 1) + 1) + 1, false, true);
                            break;
                        }
                        if (ModChecker.charmPresent && !ModChecker.buzzierBeesPresent && Bumblezone.BzModCompatibilityConfig.allowCCandlesBeeDungeon.get().booleanValue() && random.nextFloat() < 0.33f) {
                            blockState = CharmRedirection.CGetCandle(false, true);
                            break;
                        }
                        if (ModChecker.buzzierBeesPresent || random.nextFloat() < 0.6f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).func_176223_P();
                            break;
                        }
                        blockState = Blocks.field_201941_jj.func_176223_P();
                        break;
                    }
                    case "inner_ring": {
                        if (ModChecker.buzzierBeesPresent && random.nextFloat() < 0.4f && Bumblezone.BzModCompatibilityConfig.allowScentedCandlesBeeDungeon.get().booleanValue()) {
                            blockState = BuzzierBeesRedirection.BBGetRandomTier2Candle((Random)random, Bumblezone.BzModCompatibilityConfig.powerfulCandlesRarityBeeDungeon.get(), random.nextInt(random.nextInt(3) + 1) + 1, false, true);
                            break;
                        }
                        if (ModChecker.charmPresent && Bumblezone.BzModCompatibilityConfig.allowCCandlesBeeDungeon.get().booleanValue() && (ModChecker.buzzierBeesPresent ? random.nextFloat() < 0.05f : random.nextFloat() < 0.25f)) {
                            blockState = CharmRedirection.CGetCandle(false, true);
                            break;
                        }
                        if (ModChecker.buzzierBeesPresent ? random.nextBoolean() : random.nextFloat() < 0.35f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).func_176223_P();
                            break;
                        }
                        blockState = Blocks.field_201941_jj.func_176223_P();
                        break;
                    }
                    case "outer_ring": {
                        if (ModChecker.buzzierBeesPresent && random.nextFloat() < 0.25f && Bumblezone.BzModCompatibilityConfig.allowScentedCandlesBeeDungeon.get().booleanValue()) {
                            blockState = BuzzierBeesRedirection.BBGetRandomTier1Candle((Random)random, random.nextInt(3) + 1, false, true);
                            break;
                        }
                        if (ModChecker.charmPresent && Bumblezone.BzModCompatibilityConfig.allowCCandlesBeeDungeon.get().booleanValue() && (ModChecker.buzzierBeesPresent ? random.nextFloat() < 0.1f : random.nextFloat() < 0.2f)) {
                            blockState = CharmRedirection.CGetCandle(false, true);
                            break;
                        }
                        if (random.nextFloat() < 0.45f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).func_176223_P();
                            break;
                        }
                        blockState = Blocks.field_201941_jj.func_176223_P();
                        break;
                    }
                }
            }
        } else if (blockState.func_203425_a(Blocks.field_226908_md_) || blockState.func_203425_a((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            blockState = ModChecker.productiveBeesPresent && (double)random.nextFloat() < Bumblezone.BzModCompatibilityConfig.PBOreHoneycombSpawnRateBeeDungeon.get() ? ProductiveBeesRedirection.PBGetRandomHoneycomb((Random)random, Bumblezone.BzModCompatibilityConfig.PBGreatHoneycombRarityBeeDungeon.get()) : (ModChecker.resourcefulBeesPresent && (double)random.nextFloat() < Bumblezone.BzModCompatibilityConfig.RBOreHoneycombSpawnRateBeeDungeon.get() ? ResourcefulBeesRedirection.RBGetRandomHoneycomb((Random)random, Bumblezone.BzModCompatibilityConfig.RBGreatHoneycombRarityBeeDungeon.get()) : (random.nextFloat() < 0.4f ? Blocks.field_226908_md_.func_176223_P() : ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P()));
        } else if (blockState.func_203425_a((Block)BzBlocks.HONEYCOMB_BROOD.get())) {
            blockState = random.nextFloat() < 0.6f ? (BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).func_176223_P().func_206870_a((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.nextInt(3)))).func_206870_a((Property)HoneycombBrood.field_176387_N, blockState.func_177229_b((Property)HoneycombBrood.field_176387_N)) : (random.nextFloat() < 0.2f ? Blocks.field_226907_mc_.func_176223_P() : (ModChecker.resourcefulBeesPresent && random.nextFloat() < 0.1f ? ResourcefulBeesRedirection.getRBHoneyBlock((Random)random) : ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P()));
        } else if (blockState.func_203425_a((Block)BzFluids.SUGAR_WATER_BLOCK.get()) && random.nextFloat() < 0.1f) {
            blockState = (BlockState)((Block)BzBlocks.HONEY_CRYSTAL.get()).func_176223_P().func_206870_a((Property)HoneyCrystal.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return new Template.BlockInfo(worldPos, blockState, structureBlockInfoWorld.field_186244_c);
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return BzProcessors.BEE_DUNGEON_PROCESSOR;
    }
}

