/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.bumblezone.entities;

import com.telepathicgrunt.bumblezone.Bumblezone;
import com.telepathicgrunt.bumblezone.client.MusicHandler;
import com.telepathicgrunt.bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.bumblezone.modinit.BzEffects;
import com.telepathicgrunt.bumblezone.tags.BZBlockTags;
import com.telepathicgrunt.bumblezone.tags.BZItemTags;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1311;
import net.minecraft.class_1440;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_4466;
import org.apache.logging.log4j.Level;

public class BeeAggression {
    private static final Set<class_1299<?>> SET_OF_BEE_HATED_ENTITIES = new HashSet();

    public static void setupEvents() {
        ServerWorldEvents.LOAD.register((minecraftServer, serverWorld) -> BeeAggression.setupBeeHatingList((class_1937)serverWorld));
        PlayerBlockBreakEvents.AFTER.register((world, playerEntity, blockPos, blockState, blockEntity) -> BeeAggression.blockBreakAnger(playerEntity, blockState.method_26204()));
    }

    public static void setupBeeHatingList(class_1937 world) {
        if (SET_OF_BEE_HATED_ENTITIES.size() != 0) {
            return;
        }
        for (class_1299 entityType : class_2378.field_11145) {
            class_1297 entity;
            if (entityType.method_5891() != class_1311.field_6302 && entityType.method_5891() != class_1311.field_6294 && entityType.method_5891() != class_1311.field_6303) continue;
            try {
                entity = entityType.method_5883(world);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.log(Level.WARN, "Failed to temporary create " + class_2378.field_11145.method_29113((Object)entityType) + " mob in order to check if it is an arthropod that bees should be naturally angry at. Will check if mob is a bear or wasp in its name instead. Error message is: " + e.getMessage());
                String mobName = class_2378.field_11145.method_29113((Object)entityType).toString();
                if (!mobName.contains("bear") && !mobName.contains("wasp")) continue;
                SET_OF_BEE_HATED_ENTITIES.add(entityType);
                continue;
            }
            if (!(entity instanceof class_1308)) continue;
            String mobName = class_2378.field_11145.method_10221((Object)entityType).toString();
            class_1308 mobEntity = (class_1308)entity;
            if ((mobEntity.method_6046() != class_1310.field_6293 || mobName.contains("bee")) && !(mobEntity instanceof class_1440) && !mobName.contains("bear") && !mobName.contains("wasp")) continue;
            SET_OF_BEE_HATED_ENTITIES.add(entityType);
        }
    }

    public static void blockBreakAnger(class_1657 player, class_2248 block) {
        if (BZBlockTags.WRATH_ACTIVATING_BLOCKS_WHEN_MINED.method_15141((Object)block)) {
            BeeAggression.angerBees(player);
        }
    }

    public static void itemPickupAnger(class_1657 player, class_1792 item) {
        if (BZItemTags.WRATH_ACTIVATING_ITEMS_WHEN_PICKED_UP.method_15141((Object)item)) {
            BeeAggression.angerBees(player);
        }
    }

    private static void angerBees(class_1657 player) {
        if ((player.method_5770().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone) && Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.aggressiveBees && !player.method_7337() && !player.method_7325()) {
            if (player.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
                player.method_6016(BzEffects.PROTECTION_OF_THE_HIVE);
            } else {
                player.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.howLongWrathOfTheHiveLasts, 2, false, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.showWrathOfTheHiveParticles, true));
            }
        }
    }

    public static void beeHitAndAngered(class_1297 entity, class_1297 attackerEntity) {
        if (!entity.field_6002.field_9236 && (entity.method_5770().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) || Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone) && Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.aggressiveBees && entity instanceof class_4466 && attackerEntity != null) {
            if (attackerEntity instanceof class_1657 && !((class_1657)attackerEntity).method_7337() && !attackerEntity.method_7325()) {
                class_1657 player = (class_1657)attackerEntity;
                if (player.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
                    player.method_6016(BzEffects.PROTECTION_OF_THE_HIVE);
                    WrathOfTheHiveEffect.calmTheBees(player.field_6002, (class_1309)player);
                } else {
                    player.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.howLongWrathOfTheHiveLasts, 2, false, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.showWrathOfTheHiveParticles, true));
                }
            } else if (attackerEntity instanceof class_1308) {
                class_1308 mob = (class_1308)attackerEntity;
                if (mob.method_6059(BzEffects.PROTECTION_OF_THE_HIVE)) {
                    mob.method_6016(BzEffects.PROTECTION_OF_THE_HIVE);
                    WrathOfTheHiveEffect.calmTheBees(mob.field_6002, (class_1309)mob);
                } else {
                    mob.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.howLongWrathOfTheHiveLasts, 2, false, true));
                }
            }
        }
    }

    public static void entityTypeBeeAnger(class_1297 entity) {
        if (BeeAggression.doesBeesHateEntity(entity)) {
            ((class_1308)entity).method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.howLongWrathOfTheHiveLasts, 1, false, true));
        }
    }

    public static boolean doesBeesHateEntity(class_1297 entity) {
        if (!entity.field_6002.field_9236 && entity.method_5770().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) && Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.aggressiveBees && entity instanceof class_1308) {
            class_1308 mobEntity = (class_1308)entity;
            return SET_OF_BEE_HATED_ENTITIES.contains(entity.method_5864()) && !mobEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE);
        }
        return false;
    }

    public static void playerTick(class_1657 playerEntity) {
        if (!playerEntity.field_6002.method_8608() && playerEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE) && !Bumblezone.BZ_CONFIG.BZBeeAggressionConfig.allowWrathOfTheHiveOutsideBumblezone && !playerEntity.method_5770().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            playerEntity.method_6016(BzEffects.WRATH_OF_THE_HIVE);
            WrathOfTheHiveEffect.calmTheBees(playerEntity.field_6002, (class_1309)playerEntity);
        }
        if (playerEntity.field_6002.method_8608()) {
            boolean wrathEffect = playerEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE);
            if (wrathEffect) {
                MusicHandler.playAngryBeeMusic(playerEntity);
            }
            if (!WrathOfTheHiveEffect.ACTIVE_WRATH && wrathEffect) {
                WrathOfTheHiveEffect.ACTIVE_WRATH = true;
            } else if (WrathOfTheHiveEffect.ACTIVE_WRATH && !wrathEffect) {
                MusicHandler.stopAngryBeeMusic(playerEntity);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.field_6002, (class_1309)playerEntity);
                WrathOfTheHiveEffect.ACTIVE_WRATH = false;
            }
        }
    }
}

