/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.bumblezone.modcompat;

import com.telepathicgrunt.bumblezone.Bumblezone;
import com.telepathicgrunt.bumblezone.modcompat.BeeBetterCompat;
import com.telepathicgrunt.bumblezone.modcompat.CharmCompat;
import com.telepathicgrunt.bumblezone.modcompat.PotionOfBeesCompat;
import java.util.concurrent.Callable;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Level;

public class ModChecker {
    public static boolean potionOfBeesPresent = false;
    public static boolean beeBetterPresent = false;
    public static boolean charmPresent = false;

    public static void setupModCompat() {
        String currentModID = "";
        try {
            currentModID = "potionofbees";
            ModChecker.loadupModCompat(currentModID, () -> PotionOfBeesCompat.setupPotionOfBees());
            currentModID = "beebetter";
            ModChecker.loadupModCompat(currentModID, () -> BeeBetterCompat.setupBeeBetter());
            currentModID = "charm";
            ModChecker.loadupModCompat(currentModID, () -> CharmCompat.setupCharm());
        }
        catch (Exception e) {
            ModChecker.printErrorToLogs("classloading " + currentModID + " and so, mod compat done afterwards broke");
            e.printStackTrace();
        }
    }

    private static void loadupModCompat(String modid, Runnable runnable) {
        try {
            if (FabricLoader.getInstance().isModLoaded(modid)) {
                runnable.run();
            }
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs(modid);
            e.printStackTrace();
        }
    }

    private static void printErrorToLogs(String currentModID) {
        Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
        Bumblezone.LOGGER.log(Level.INFO, " ");
        Bumblezone.LOGGER.log(Level.INFO, "ERROR: Something broke when trying to add mod compatibility with" + currentModID + ". Please let The Bumblezone developer (TelepathicGrunt) know about this!");
        Bumblezone.LOGGER.log(Level.INFO, " ");
        Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
    }

    public static void runSetupForMod(Callable<Runnable> toRun) throws Exception {
        toRun.call().run();
    }
}

