/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client;

import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import quek.undergarden.client.render.entity.BruteRender;
import quek.undergarden.client.render.entity.DwellerRender;
import quek.undergarden.client.render.entity.ForgottenGuardianRender;
import quek.undergarden.client.render.entity.GloomperRender;
import quek.undergarden.client.render.entity.GwibRender;
import quek.undergarden.client.render.entity.GwiblingRender;
import quek.undergarden.client.render.entity.MasticatorRender;
import quek.undergarden.client.render.entity.MinionRender;
import quek.undergarden.client.render.entity.MuncherRender;
import quek.undergarden.client.render.entity.NargoyleRender;
import quek.undergarden.client.render.entity.RotDwellerRender;
import quek.undergarden.client.render.entity.RotbeastRender;
import quek.undergarden.client.render.entity.RotlingRender;
import quek.undergarden.client.render.entity.RotwalkerRender;
import quek.undergarden.client.render.entity.ScintlingRender;
import quek.undergarden.client.render.entity.SploogieRender;
import quek.undergarden.client.render.entity.StonebornRender;
import quek.undergarden.client.render.entity.UGBoatRenderer;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGFluids;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="undergarden", value={Dist.CLIENT})
public class UndergardenClient {
    private static void render(Supplier<? extends Block> block, RenderType render) {
        RenderTypeLookup.setRenderLayer((Block)block.get(), (RenderType)render);
    }

    public static void registerBlockRenderers() {
        RenderType cutout = RenderType.func_228643_e_();
        RenderType mipped = RenderType.func_228641_d_();
        RenderType translucent = RenderType.func_228645_f_();
        UndergardenClient.render(UGBlocks.DEEPTURF_BLOCK, mipped);
        UndergardenClient.render(UGBlocks.DEEPTURF, cutout);
        UndergardenClient.render(UGBlocks.SHIMMERWEED, cutout);
        UndergardenClient.render(UGBlocks.SMOGSTEM_SAPLING, cutout);
        UndergardenClient.render(UGBlocks.WIGGLEWOOD_SAPLING, cutout);
        UndergardenClient.render(UGBlocks.INDIGO_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.VEIL_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.INK_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.BLOOD_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.UNDERBEAN_BUSH, cutout);
        UndergardenClient.render(UGBlocks.DITCHBULB_PLANT, cutout);
        UndergardenClient.render(UGBlocks.TALL_DEEPTURF, cutout);
        UndergardenClient.render(UGBlocks.TALL_SHIMMERWEED, cutout);
        UndergardenClient.render(UGBlocks.CLOGGRUM_BARS, cutout);
        UndergardenClient.render(UGBlocks.GLOWING_KELP, cutout);
        UndergardenClient.render(UGBlocks.GLOWING_KELP_PLANT, cutout);
        UndergardenClient.render(UGBlocks.GOO, translucent);
        UndergardenClient.render(UGBlocks.SMOGSTEM_DOOR, cutout);
        UndergardenClient.render(UGBlocks.WIGGLEWOOD_DOOR, cutout);
        UndergardenClient.render(UGBlocks.SMOGSTEM_TRAPDOOR, cutout);
        UndergardenClient.render(UGBlocks.WIGGLEWOOD_TRAPDOOR, cutout);
        UndergardenClient.render(UGBlocks.ASHEN_DEEPTURF, cutout);
        UndergardenClient.render(UGBlocks.BLISTERBERRY_BUSH, cutout);
        UndergardenClient.render(UGBlocks.GLOOMGOURD_STEM, cutout);
        UndergardenClient.render(UGBlocks.GLOOMGOURD_STEM_ATTACHED, cutout);
        UndergardenClient.render(UGBlocks.SHARD_TORCH, cutout);
        UndergardenClient.render(UGBlocks.SHARD_WALL_TORCH, cutout);
        UndergardenClient.render(UGBlocks.DROOPVINE_TOP, cutout);
        UndergardenClient.render(UGBlocks.DROOPVINE, cutout);
        UndergardenClient.render(UGBlocks.GRONGLET, cutout);
        UndergardenClient.render(UGBlocks.GRONGLE_DOOR, cutout);
        UndergardenClient.render(UGBlocks.GRONGLE_TRAPDOOR, cutout);
        UndergardenClient.render(UGBlocks.VIRULENT_MIX, translucent);
        UndergardenClient.render(UGBlocks.SEEPING_INK, cutout);
        UndergardenClient.render(UGBlocks.MUSHROOM_VEIL, cutout);
        UndergardenClient.render(UGBlocks.MUSHROOM_VEIL_TOP, cutout);
        UndergardenClient.render(UGBlocks.POTTED_SHIMMERWEED, cutout);
        UndergardenClient.render(UGBlocks.POTTED_SMOGSTEM_SAPLING, cutout);
        UndergardenClient.render(UGBlocks.POTTED_WIGGLEWOOD_SAPLING, cutout);
        UndergardenClient.render(UGBlocks.POTTED_INDIGO_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.POTTED_VEIL_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.POTTED_INDIGO_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.POTTED_INK_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.POTTED_BLOOD_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.POTTED_GRONGLET, cutout);
        UndergardenClient.render(UGBlocks.FROZEN_DEEPTURF, cutout);
    }

    public static void registerEntityRenderers() {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.SLINGSHOT_AMMO.get()), entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.GOO_BALL.get()), entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.ROTTEN_BLISTERBERRY.get()), entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.BLISTERBOMB.get()), entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.MINION_PROJECTILE.get()), entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.BOAT.get()), UGBoatRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.ROTLING.get()), RotlingRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.ROTWALKER.get()), RotwalkerRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.ROTBEAST.get()), RotbeastRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.DWELLER.get()), DwellerRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.ROTDWELLER.get()), RotDwellerRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.GWIBLING.get()), GwiblingRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.BRUTE.get()), BruteRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.SCINTLING.get()), ScintlingRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.GLOOMPER.get()), GloomperRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.STONEBORN.get()), StonebornRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.MASTICATOR.get()), MasticatorRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.NARGOYLE.get()), NargoyleRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get()), ForgottenGuardianRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.MUNCHER.get()), MuncherRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.SPLOOGIE.get()), SploogieRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.MINION.get()), MinionRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UGEntityTypes.GWIB.get()), GwibRender::new);
    }

    public static void registerBlockColors() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        colors.func_186722_a((state, world, pos, tint) -> world != null && pos != null ? BiomeColors.func_228358_a_((IBlockDisplayReader)world, (BlockPos)pos) : new Color(91, 117, 91).getRGB(), new Block[]{(Block)UGBlocks.DEEPTURF_BLOCK.get(), (Block)UGBlocks.DEEPTURF.get(), (Block)UGBlocks.SHIMMERWEED.get(), (Block)UGBlocks.TALL_DEEPTURF.get(), (Block)UGBlocks.TALL_SHIMMERWEED.get(), (Block)UGBlocks.GLOOMGOURD_STEM.get(), (Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get(), (Block)UGBlocks.POTTED_SHIMMERWEED.get()});
        colors.func_186722_a((state, world, pos, tint) -> new Color(54, 45, 66).getRGB(), new Block[]{(Block)UGBlocks.GLOOMGOURD_STEM.get(), (Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get()});
    }

    public static void registerItemColors() {
        BlockColors bColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors iColors = Minecraft.func_71410_x().getItemColors();
        iColors.func_199877_a((stack, tint) -> bColors.func_228054_a_(((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P(), null, null, 0), new IItemProvider[]{(IItemProvider)UGBlocks.DEEPTURF_BLOCK.get(), (IItemProvider)UGBlocks.DEEPTURF.get(), (IItemProvider)UGBlocks.SHIMMERWEED.get(), (IItemProvider)UGBlocks.TALL_SHIMMERWEED.get(), (IItemProvider)UGBlocks.TALL_DEEPTURF.get()});
        iColors.func_199877_a((stack, tint) -> {
            if (tint == 0) {
                return new Color(91, 117, 91).getRGB();
            }
            return -1;
        }, new IItemProvider[]{(IItemProvider)UGBlocks.SHIMMERWEED.get(), (IItemProvider)UGBlocks.TALL_SHIMMERWEED.get()});
    }

    @SubscribeEvent
    public static void renderVirulentFogColor(EntityViewRenderEvent.FogColors event) {
        ActiveRenderInfo info = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        FluidState fluidState = info.func_216771_k();
        if (fluidState.func_206886_c() == UGFluids.VIRULENT_MIX_FLOWING.get() || fluidState.func_206886_c() == UGFluids.VIRULENT_MIX_SOURCE.get()) {
            event.setRed(0.22352941f);
            event.setGreen(0.09803922f);
            event.setBlue(0.3137255f);
        }
    }

    @SubscribeEvent
    public static void renderVirulentFogDensity(EntityViewRenderEvent.FogDensity event) {
        ActiveRenderInfo info = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        FluidState fluidState = info.func_216771_k();
        if (fluidState.func_206886_c() == UGFluids.VIRULENT_MIX_FLOWING.get() || fluidState.func_206886_c() == UGFluids.VIRULENT_MIX_SOURCE.get()) {
            event.setDensity(1.5f);
            event.setCanceled(true);
        }
    }
}

