/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import quek.undergarden.entity.boss.ForgottenGuardianEntity;

public class ForgottenGuardianModel<T extends ForgottenGuardianEntity>
extends SegmentedModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer body;
    private final ModelRenderer leftArm;
    private final ModelRenderer rightArm;
    private final ModelRenderer leftLeg;
    private final ModelRenderer rightLeg;

    public ForgottenGuardianModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, -20.0f, 0.0f);
        this.head.func_78784_a(42, 10).func_228303_a_(-3.0f, -15.0f, -3.0f, 6.0f, 8.0f, 6.0f, 0.0f, false);
        this.head.func_78784_a(60, 4).func_228303_a_(-2.0f, -15.0f, -2.0f, 4.0f, 8.0f, 4.0f, 0.0f, false);
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 24.0f, 0.0f);
        this.body.func_78784_a(0, 0).func_228303_a_(-8.0f, -51.0f, -4.0f, 16.0f, 8.0f, 8.0f, 0.0f, false);
        this.body.func_78784_a(0, 27).func_228303_a_(-6.0f, -43.0f, -3.0f, 12.0f, 13.0f, 6.0f, 0.0f, false);
        this.body.func_78784_a(0, 16).func_228303_a_(-7.0f, -30.0f, -4.0f, 14.0f, 3.0f, 8.0f, 0.0f, false);
        this.body.func_78784_a(36, 36).func_228303_a_(-3.0f, -27.0f, -4.0f, 6.0f, 3.0f, 8.0f, 0.0f, false);
        this.body.func_78784_a(30, 27).func_228303_a_(-10.0f, -49.0f, -1.0f, 20.0f, 2.0f, 2.0f, 0.0f, false);
        this.body.func_78784_a(74, 21).func_228303_a_(-1.0f, -51.0f, -1.0f, 2.0f, 8.0f, 2.0f, 0.0f, false);
        this.leftArm = new ModelRenderer((Model)this);
        this.leftArm.func_78793_a(10.0f, -24.0f, 0.0f);
        this.leftArm.func_78784_a(0, 64).func_228303_a_(0.0f, -1.0f, -1.0f, 2.0f, 16.0f, 2.0f, 0.0f, false);
        this.leftArm.func_78784_a(0, 46).func_228303_a_(-1.0f, 15.0f, -2.0f, 4.0f, 14.0f, 4.0f, 0.0f, true);
        this.rightArm = new ModelRenderer((Model)this);
        this.rightArm.func_78793_a(-10.0f, -24.0f, 0.0f);
        this.rightArm.func_78784_a(0, 64).func_228303_a_(-2.0f, -1.0f, -1.0f, 2.0f, 16.0f, 2.0f, 0.0f, true);
        this.rightArm.func_78784_a(0, 46).func_228303_a_(-3.0f, 15.0f, -2.0f, 4.0f, 14.0f, 4.0f, 0.0f, false);
        this.leftLeg = new ModelRenderer((Model)this);
        this.leftLeg.func_78793_a(-3.0f, -2.0f, 0.0f);
        this.leftLeg.func_78784_a(8, 64).func_228303_a_(-2.0f, -1.0f, -1.0f, 2.0f, 14.0f, 2.0f, 0.0f, true);
        this.leftLeg.func_78784_a(16, 46).func_228303_a_(-3.0f, 13.0f, -2.0f, 4.0f, 13.0f, 4.0f, 0.0f, false);
        this.rightLeg = new ModelRenderer((Model)this);
        this.rightLeg.func_78793_a(3.0f, -2.0f, 0.0f);
        this.rightLeg.func_78784_a(8, 64).func_228303_a_(0.0f, -1.0f, -1.0f, 2.0f, 14.0f, 2.0f, 0.0f, false);
        this.rightLeg.func_78784_a(16, 46).func_228303_a_(-1.0f, 13.0f, -2.0f, 4.0f, 13.0f, 4.0f, 0.0f, true);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.leftLeg.field_78795_f = -1.5f * MathHelper.func_233021_e_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightLeg.field_78795_f = 1.5f * MathHelper.func_233021_e_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftLeg.field_78796_g = 0.0f;
        this.rightLeg.field_78796_g = 0.0f;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        int attackTimer = ((ForgottenGuardianEntity)((Object)entityIn)).getAttackTimer();
        if (attackTimer > 0) {
            this.rightArm.field_78795_f = -2.0f + 1.5f * MathHelper.func_233021_e_((float)((float)attackTimer - partialTick), (float)10.0f);
            this.leftArm.field_78795_f = -2.0f + 1.5f * MathHelper.func_233021_e_((float)((float)attackTimer - partialTick), (float)10.0f);
        } else {
            this.rightArm.field_78795_f = (-0.2f + 1.5f * MathHelper.func_233021_e_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftArm.field_78795_f = (-0.2f - 1.5f * MathHelper.func_233021_e_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.body.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.leftArm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.rightArm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.leftLeg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.rightLeg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableSet.of((Object)this.head, (Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg, (Object[])new ModelRenderer[0]);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

